###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
#
# Build a TAR archive for a MIRA package using tar.
#
# This cmake script file needs the following variables to be defined:
#
#   MIRA_INSTALL_PACKAGE:          Name of the package
#   MIRA_INSTALL_VERSION:          API-Version
#   MIRA_INSTALL_RELEASE:          Build version
#   MIRA_INSTALL_COMPONENTS:       Components of this package
#
#   MIRA_ROOT_DIR:                 Path to MIRA to locate some files.
#   BUILD_BINARY_DIR:              Current build environment
#
# Author: Christian Martin
#
###############################################################################

SET(INSTALL_ROOT          "${BUILD_BINARY_DIR}/install_root")
SET(CMAKEINSTALL_PATH     "${INSTALL_ROOT}/_install_")

SET(MIRA_INSTALL_PREFIX    "/opt/MIRA")

###############################################################################
# cleanup and re-create all directories

FILE(REMOVE_RECURSE ${INSTALL_ROOT})

MAKE_DIRECTORY(${CMAKEINSTALL_PATH})

###############################################################################
# Install all cmake components for the current package

FOREACH(component ${MIRA_INSTALL_COMPONENTS})
	EXEC_PROGRAM(${CMAKE_COMMAND} ARGS
		-D "BUILD_TYPE=Release"
		-D "CMAKE_INSTALL_DO_STRIP=1"
		-D "CMAKE_INSTALL_COMPONENT=${component}"
		-D "CMAKE_INSTALL_PREFIX=${CMAKEINSTALL_PATH}/${MIRA_INSTALL_PREFIX}"
		-P "${BUILD_BINARY_DIR}/cmake_install.cmake"
	)
ENDFOREACH()

###############################################################################
# Check if there is at least one file installed.

FILE(GLOB_RECURSE FileList "${CMAKEINSTALL_PATH}/${MIRA_INSTALL_PREFIX}/*")
LIST(LENGTH FileList FileListLen)
IF(${FileListLen} EQUAL 0)
	MESSAGE(STATUS "*** Skip building TAR for package ${MIRA_INSTALL_PACKAGE}, since there are no files to install.")
	RETURN()
ENDIF()

###############################################################################
# get some more system information

EXEC_PROGRAM(uname ARGS -m OUTPUT_VARIABLE SYSTEM_ARCH)

###############################################################################
# Create the archive for all files
###############################################################################

SET(tarFileName MIRA-${MIRA_INSTALL_PACKAGE}-${MIRA_INSTALL_VERSION}-${MIRA_INSTALL_RELEASE}-${SYSTEM_ARCH}.tar.bz2)

MESSAGE(STATUS "*** Building TAR package ${tarFileName}")

EXEC_PROGRAM(tar ${CMAKEINSTALL_PATH}/${MIRA_INSTALL_PREFIX} ARGS
	cjf ${BUILD_BINARY_DIR}/${tarFileName} *
)

###############################################################################
# Clean up

FILE(REMOVE_RECURSE ${INSTALL_ROOT})
