/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file SpinBoxDelegate.h
 *    Delegate that requires double values and provides a spin box as editor.
 *
 * @author Christian Reuther
 * @date   2012/02/07
 */

#ifndef _MIRA_SPINBOXDELEGATE_H_
#define _MIRA_SPINBOXDELEGATE_H_

#include <QStyledItemDelegate>
#include <QDoubleSpinBox>
#include <QSpinBox>

#include <widgets/GuiWidgetsExports.h>

namespace mira {

////////////////////////////////////////////////////////////////////////////////

MIRA_GUI_WIDGETS_EXPORT QDoubleSpinBox* createDoubleSpinBox(QWidget* parent, double minRange,
                                                            double maxRange, double step,
                                                            double defvalue, const QString& suffix = "",
                                                            bool buttons = true, bool readonly = false,
                                                            unsigned int decimals = 2);

MIRA_GUI_WIDGETS_EXPORT QSpinBox* createSpinBox(QWidget* parent, int min, int max, int step,
                                                int defvalue, const QString& suffix = "",
                                                bool buttons = true, bool readonly = false);

////////////////////////////////////////////////////////////////////////////////

/**
 * Delegate for a QTableWidgetItem (or any model-view item for that matter). Is
 * able to format a double value to two decimals precision
 */
class MIRA_GUI_WIDGETS_EXPORT SpinBoxDelegate : public QStyledItemDelegate {

public:
	SpinBoxDelegate(QObject *parent = 0);
	virtual ~SpinBoxDelegate();

public:
	/*
	 * Methods to change the appearance of the QDoubleSpinBox displayed as the editor.
	 */
	void setSpinBoxFormat(double minRange, double maxRange, double step, double defvalue,
	                      const QString& suffix = "", bool buttons = true, unsigned int decimals = 2);
	void setRange(double minRange, double maxRange, double step);
	void setDefaultValue(double defvalue);
	void setSuffix(const QString& suffix);
	void setShowButtons(bool show);
	void setDecimals(unsigned int decimals);

public:
	/*
	 * Qt methods to display the delegate item, create the editor, ...
	 */
	QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option,
	                      const QModelIndex &index) const;

	void setEditorData(QWidget *editor, const QModelIndex &index) const;
	void setModelData(QWidget *editor, QAbstractItemModel *model,
	                  const QModelIndex &index) const;

	void updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option,
	                          const QModelIndex &index) const;

	QString displayText(const QVariant &value, const QLocale &locale) const;

private:
	double mMinRange;
	double mMaxRange;
	double mStep;
	double mDefValue;
	QString mSuffix;
	bool mShowButtons;
	unsigned int mDecimals;
};

////////////////////////////////////////////////////////////////////////////////

}

#endif
