/*
 * Copyright (C) 2014 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file PolygonTool2D.h
 *    Tool for specifying a polygon in the 2D graphics view.
 *
 * @author Christian Reuther
 * @date   2018/08/29
 */

#ifndef _MIRA_POLYGONTOOL2D_H_
#define _MIRA_POLYGONTOOL2D_H_

#include <visualization/VisualizationTool2D.h>

#include <QGraphicsPolygonItem>
#include <geometry/Polygon.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class PathPointItem : public QAbstractGraphicsShapeItem
{
public:
	PathPointItem(qreal radius = 2.0, QGraphicsItem* parent = NULL);
	virtual ~PathPointItem();

	virtual QRectF boundingRect() const;

protected: // Override these to customize the look of the handle
	virtual void paint(QPainter* painter, const QStyleOptionGraphicsItem*, QWidget*);

	const qreal RADIUS;
};

///////////////////////////////////////////////////////////////////////////////

class MIRA_GUI_VISUALIZATION_EXPORT PolygonTool2D : public VisualizationTool2D
{
	MIRA_META_OBJECT(PolygonTool2D,
			("Name", "Polygon")
			("Category", "Interact")
			("Description", "Define a polygon in the 2D view")
			("Default", "false")
			("Order", "400"))

public:
	PolygonTool2D();
	virtual ~PolygonTool2D();

	template<typename Reflector> void reflect(Reflector& r) {
		MIRA_REFLECT_BASE(r, VisualizationTool2D);
	}

	Polygon2f polygon() const;
	QPen pen() const;
	QBrush brush() const;

	void setPen(QPen pen);
	void setBrush(QBrush brush);

public:
	virtual void onMousePressed(QMouseEvent* e);
	virtual void onMouseReleased(QMouseEvent* e);

	virtual void activate();
	virtual void deactivate();
	virtual void reset();

	virtual QIcon getIcon();

protected:
	virtual void init(IVisualizationSite* site);
	virtual QGraphicsItem* setupScene(QGraphicsScene* mgr);

protected:
	/// overwrite this method to be notified whenever the user clicks right mouse button
	virtual void onNewPolygon(const Polygon2f& polygon) {};

protected:
	void updatePenAndBrush();

	QGraphicsItemGroup* mItem;
	QGraphicsPolygonItem* mPolygonItem;
	QVector<PathPointItem*> mPointItems;

	QPen mPen;
	QBrush mBrush;

	QVector<QPointF> mPathPoints;
};

///////////////////////////////////////////////////////////////////////////////

}

#endif
