/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file TapePlayerWidget.h
 *    Widget for playing back tapes.
 *
 * @author Tim Langner
 * @date   2012/03/02
 */

#ifndef _MIRA_TAPEPLAYERWIDGET_H_
#define _MIRA_TAPEPLAYERWIDGET_H_

#include <QTimer>
#include <QCheckBox>
#include <QPushButton>
#include <QToolButton>
#include <QLabel>
#include <QSlider>
#include <QWidget>

#include <fw/Framework.h>
#include <fw/TapeVisitor.h>

#include <fw/GuiFwExports.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class TapePlayer;

class MIRA_GUI_FW_EXPORT TapePlayerWidget : public QWidget
{
	Q_OBJECT
public:

	TapePlayerWidget(QWidget* parent);
	void setupUi();

	void openTapes(const QStringList& tapeFiles, boost::optional<std::vector<std::string>> channelsToPlay = boost::optional<std::vector<std::string>>());
	void closeTapes();

public slots:

	void open();
	void stop();
	void play();
	void step();
	void check();
	void startJump();
	void autoStep();
	void pause(bool pause);
	void moveJump(int time);
	void jump();
	void jumpToTime(Duration time);
	void setSpeed(int speed);
	void stepToChanged(bool state);
	void autoStepToChanged(bool state);
	void loopChanged(bool state);
	void pauseControlChanged(bool state);
	void selectChannels();

signals:

	void onOpen(const QStringList& files, bool useOriginalTimestamp, const QString& namespacePrefix);
	void onStop();
	void onAutoStep();
	void onPauseControl(bool pause);

protected:

	int32 getLoopCount() const;
	void onAutoStep(ChannelRead<void> data);
	void onPauseControl(ChannelRead<bool> data);

public:

	boost::shared_ptr<TapePlayer> player;
	TapeVisitor visitor;
	std::map<QString, Tape*> tapes;
	QSlider* slider;
	QLabel* info;
	QToolButton* btOpen;
	QToolButton* btStop;
	QToolButton* btPlay;
	QToolButton* btStep;
	QToolButton* cbLoop;
	QToolButton* btChannels;
	QAction* actStep;
	QAction* actAutoStep;
	QAction* actPauseControl;
	QMenu* loopMenu;
	std::vector<QAction*> actLoopCount;
	int32 loopCount;
	QLabel* lblSpeed;
	QSlider* speed;
	QTimer checkTimer;

	QStringList lastTapes;
	boost::optional<std::vector<std::string>> lastChannelsToPlay;

	std::string mStepToChannel;
	std::string mAutoStepChannel;
	std::string mPauseControlChannel;
	bool useOriginalTimestamp;
	std::string namespacePrefix;
	Time lastTime;
};

///////////////////////////////////////////////////////////////////////////////

}

#endif 
