/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file QtUnit.h
 *    Unit that processes its dispatcher within Qt's main thread.
 *
 * @author Erik Einhorn
 * @date   2011/09/14
 */

#ifndef _MIRA_QTUNIT_H_
#define _MIRA_QTUNIT_H_

#include <QCoreApplication>
#include <QObject>
#include <QTimerEvent>

#include <fw/MicroUnit.h>
#include <fw/GuiFwExports.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * A unit that processes its dispatcher within Qt's main thread.
 */
class MIRA_GUI_FW_EXPORT QtUnit : public QObject, public MicroUnit
{
	Q_OBJECT
	MIRA_OBJECT(QtUnit)
protected:

	/**
	 * Constructs a Qt unit.
	 */
	QtUnit(Flags flags = NORMAL);

public:
	/// Destructor
	virtual ~QtUnit();

	/// start with default dispatcher thread interval (50ms)
	virtual void start();

	/// start with custom dispatcher thread interval
	virtual void start(int interval);

public slots:
	void onAboutToQuit();

protected:

	virtual void timerEvent(QTimerEvent* event);

protected:
	int mCycleTimer;
};

///////////////////////////////////////////////////////////////////////////////

} // namespace

MIRA_NO_PUBLIC_DEFAULT_CONSTRUCTOR(QtUnit)

#endif
