/*
 * BenchmarkPublisher.C
 *
 *  Created on: 09.07.2012
 *      Author: erik
 */



#include <stdint.h>
#include <stdlib.h>

#include <yarp/os/all.h>
#include <yarp/sig/Vector.h>
#include <iostream>

#include <boost/thread.hpp>

#include "../BenchmarkStats.h"

using namespace yarp::os;
using namespace yarp::sig;

int main(int argc, char *argv[])
{
	if(argc<2) {
		std::cout << "Usage: BenchmarkPublisher Data_Size_In_KB" << std::endl;
		return -1;
	}

	const int N = atoi(argv[1]);

	// Set up YARP
	Network yarp;


	// Make two ports called /hello/in and /hello/out
	// We'll send "Bottles" (a simple nested list container) between these ports
	Port outPort;
	bool ok = outPort.open("/benchmark/out");
	if (!ok) {
		std::cout << "Failed to create ports."<< std::endl;
		return 1;
	}

	yarp.connect("/benchmark/out","/benchmark/in");

	uint64_t memStart = getMemoryUsage();

	BenchmarkStats b("Publisher");

	VectorOf<uint8_t> values;
	values.resize(N*1024);

	for(int i=0; i<100; ++i)
	{
		uint64_t memDiff1 = getMemoryUsage() - memStart;
		std::cout << "Publisher Memory1: " << memDiff1 << std::endl;

		uint64_t start = b.tic();
		uint64_t* t = reinterpret_cast<uint64_t*>(values.getFirst());
		*t = start;
		*(t+1) = i;


		// send the message
		outPort.write(values);

		b.toc();

		uint64_t memDiff2 = getMemoryUsage() - memStart;
		std::cout << "Publisher Memory2: " << memDiff2 << std::endl;

		Time::delay(0.1);
	}

	return 0;
}

