/*
 * BenchmarkPublisher.C
 *
 *  Created on: 11.07.2012
 *      Author: erik
 */

#include <lcm/lcm-cpp.hpp>

#include <stdint.h>
#include <stdlib.h>
#include <iostream>

#include <boost/thread.hpp>

#include "benchmark/Data.hpp"

#include "../BenchmarkStats.h"

int main(int argc, char *argv[])
{
	if(argc<2) {
		std::cout << "Usage: BenchmarkPublisher Data_Size_In_KB" << std::endl;
		return -1;
	}

	const int N = atoi(argv[1]);

	lcm::LCM lcm;
	if(!lcm.good())
		return 1;


	BenchmarkStats b("Publisher");
	uint64_t memStart = getMemoryUsage();

	benchmark::Data data;
	data.size = N*1024;
	data.values.resize(data.size);

	for(int i=0; i<100; ++i)
	{
		uint64_t memDiff1 = getMemoryUsage() - memStart;
		std::cout << "Publisher Memory1: " << memDiff1 << std::endl;

		uint64_t start = b.tic();
		data.timestamp = start;
		lcm.publish("benchmark", &data);
		b.toc();

		memDiff1 = getMemoryUsage() - memStart;
		std::cout << "Publisher Memory2: " << memDiff1 << std::endl;
		boost::this_thread::sleep(boost::posix_time::milliseconds(100));
	}

	return 0;
}


