/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file DiscoverService.h
 *    Service that discovers other frameworks within a network using multicast.
 *
 * @author Tim Langner
 * @date   2010/10/07
 */

#ifndef _MIRA_DISCOVERSERVICE_H_
#define _MIRA_DISCOVERSERVICE_H_

#ifndef Q_MOC_RUN
#include <boost/shared_ptr.hpp>
#endif

#include <platform/Types.h>
#include <utils/UUID.h>
#include <communication/IOService.h>

#include <fw/FrameworkExports.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * Service that is used to discover other running frameworks in the same network
 * using multicast on.
 */
class MIRA_FRAMEWORK_EXPORT DiscoverService
{
public:
	struct AnnounceMessage
	{
		uint16 port;
		UUID id;
	};

	DiscoverService();

	void startReceive();
	void handleReceive(const boost::system::error_code& error, std::size_t bytesReceived);

	void stop()
	{
		mService.stop();
		mService.join();
	}

protected:
	IOService mService;
	boost::asio::ip::udp::socket mSocket;
	boost::asio::ip::udp::endpoint mEndpoint;
	boost::asio::ip::udp::endpoint mSenderEndpoint;
	boost::asio::ip::address mMulticastAddress;
	AnnounceMessage mInfo;
};

typedef boost::shared_ptr<DiscoverService> DiscoverServicePtr;

///////////////////////////////////////////////////////////////////////////////

}

#endif
