/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file LazySingletonTestLib1.h
 *    Test library for LazySingleton test cases.
 *
 * @author Christian Martin
 * @date   2011/01/07
 */

#ifndef _MIRA_LAZYSINGLETON_TEST_LIB1_H_
#define _MIRA_LAZYSINGLETON_TEST_LIB1_H_

#include <utils/Singleton.h>

#include <platform/Types.h>

#include <iostream>

///////////////////////////////////////////////////////////////////////////////

#ifdef MIRA_WINDOWS
#  ifdef MIRA_LAZYSINGLETONTEST1_EXPORTS
#    define MIRA_LAZYSINGLETONTEST1_EXPORT __declspec(dllexport)
#  else
#    define MIRA_LAZYSINGLETONTEST1_EXPORT __declspec(dllimport)
#  endif
#else
#  define MIRA_LAZYSINGLETONTEST1_EXPORT
#endif

///////////////////////////////////////////////////////////////////////////////

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class MIRA_LAZYSINGLETONTEST1_EXPORT TestSingleton1 :
	public LazySingleton<TestSingleton1>
{
public:
	TestSingleton1();
	virtual ~TestSingleton1();

public:
	void print(const char* pMessage);

	void* self();
};

///////////////////////////////////////////////////////////////////////////////

template<typename T>
class TestSingleton2 :
	public LazySingleton< TestSingleton2<T> >
{
public:
	TestSingleton2() {
		std::cout << "TestSingleton2::CTOR(this=" << std::hex << (int64)this
		          << ")" << std::endl;
	}
	virtual ~TestSingleton2() {
		std::cout << "TestSingleton2::DTOR(this=" << std::hex << (int64)this
		          << ")" << std::endl;
	}

public:
	void print(const char* pMessage) {
		std::cout << "TestSingleton2::print(this=" << std::hex << (int64)this
		          << ") message='" << pMessage << "'" << std::endl;
	}

	void* self() {
		return((void*)this);
	}
};

typedef TestSingleton2<int> TestSingleton2Int;
typedef TestSingleton2<float> TestSingleton2Float;

///////////////////////////////////////////////////////////////////////////////

class MIRA_LAZYSINGLETONTEST1_EXPORT SingletonUser1
{
public:
	SingletonUser1();
	void useSingletons();

public:
	void* getSingleton1();
	void* getSingleton2Int();
	void* getSingleton2Float();
};

///////////////////////////////////////////////////////////////////////////////

}

#endif
