/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file MD5Test.C
 *    Test case for MD5.
 *
 * @author Christian Martin
 * @date   2010/11/26
 */

#include <boost/test/unit_test.hpp>

#include <iostream>
#include <security/MD5.h>

using namespace mira;
using namespace std;

///////////////////////////////////////////////////////////////////////////////

struct MD5TestEntry {
	const char* mData;
	const char* mDigest;
};

// Test suite from RFC1321
MD5TestEntry sMD5TestSuite[7] = {
	{ "", "d41d8cd98f00b204e9800998ecf8427e" },
	{ "a", "0cc175b9c0f1b6a831c399e269772661" },
	{ "abc", "900150983cd24fb0d6963f7d28e17f72" },
	{ "message digest", "f96b697d7cb7938d525a2f31aaf161d0" },
	{ "abcdefghijklmnopqrstuvwxyz", "c3fcd3d76192e4007dfb496cca67e13b" },
	{ "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",
	  "d174ab98d277d9f5a5611c2c9f419d9f" },
	{ "12345678901234567890123456789012345678901234567890123456789012345678901234567890",
	  "57edf4a22be3c955ac49da2e2107b67a" }
};

///////////////////////////////////////////////////////////////////////////////

BOOST_AUTO_TEST_CASE( MD5Test_func )
{
	for(int i = 0; i < 7; i++) {
		MD5 tMD5;
		tMD5.write(sMD5TestSuite[i].mData, strlen(sMD5TestSuite[i].mData));

		HashDigest tDigest = tMD5.getDigest();
		BOOST_CHECK_EQUAL(tDigest.toString(), string(sMD5TestSuite[i].mDigest));
	}
}

BOOST_AUTO_TEST_CASE( MD5Test_stream )
{
	for(int i = 0; i < 7; i++) {
		MD5 tMD5;
		tMD5 << sMD5TestSuite[i].mData;

		HashDigest tDigest = tMD5.getDigest();
		BOOST_CHECK_EQUAL(tDigest.toString(), string(sMD5TestSuite[i].mDigest));
	}
}
