/*
 * Copyright (C) by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file LibraryRegistryTest.h
 *    Tests LibraryRegistry
 *
 * @author Christof Schröter
 * @date   2020/10/06
 */

#include <boost/test/unit_test.hpp>

#include <factory/LibraryRegistry.h>
#include <factory/ManifestAgent.h>

#include <serialization/Print.h>
#include <serialization/adapters/std/map>

using namespace std;

#ifdef MIRA_WINDOWS
#  define MIRA_LIB_FOLDER "bin"
#else
#  define MIRA_LIB_FOLDER "lib"
#endif

namespace mira {

//////////////////////////////////////////////////////////////////////////////

BOOST_AUTO_TEST_CASE( LibraryRegistryTest )
{
	LibraryRegistry& registry = LibraryRegistry::instance();

	LibraryRegistry::Register reg = registry.getRegister();

	BOOST_REQUIRE_EQUAL(reg.size(), 1);
	BOOST_CHECK_EQUAL(reg.begin()->first, std::string("MIRABase"));
	BOOST_CHECK_EQUAL(reg.begin()->second.mHasManifest, false); // MIRABase has no manifest
	BOOST_CHECK_EQUAL(reg.begin()->second.mIsLoaded, true); // is linked to the test binary

	loadManifests(MIRA_LIB_FOLDER"/MIRAFramework.manifest");

	reg = registry.getRegister();
	BOOST_REQUIRE_EQUAL(reg.size(), 2);
	BOOST_CHECK_EQUAL(reg.begin()->first, std::string("MIRABase"));
	BOOST_CHECK_EQUAL(reg.begin()->second.mHasManifest, false);
	BOOST_CHECK_EQUAL(reg.begin()->second.mIsLoaded, true);
	BOOST_CHECK_EQUAL((++reg.begin())->first, std::string("MIRAFramework"));
	BOOST_CHECK_EQUAL((++reg.begin())->second.mHasManifest, true);
	BOOST_CHECK_EQUAL((++reg.begin())->second.mIsLoaded, false); // MIRAFramework not loaded

	ClassProxy proxy = ClassFactory::getClassByIdentifier("mira::MicroUnit");
	std::unique_ptr<Object> microunit{proxy.newInstance()};

	reg = registry.getRegister();
	BOOST_REQUIRE_EQUAL(reg.size(), 2);
	BOOST_CHECK_EQUAL((++reg.begin())->first, std::string("MIRAFramework"));
	BOOST_CHECK_EQUAL((++reg.begin())->second.mHasManifest, true);
	BOOST_CHECK_EQUAL((++reg.begin())->second.mIsLoaded, true); // got loaded for MicroUnit

//	std::cout << print(reg) << std::endl;
}

//////////////////////////////////////////////////////////////////////////////

} // namespace
