/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file ProgramOptions.C
 *    Implementation of ProgramOptions.h.
 *
 * @author Tim Langner
 * @date   2010/09/22
 */

#include <utils/ProgramOptions.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

ProgramOptions::ProgramOptions(int argc, char** argv,
                               const std::string& helpCategory) :
		mOptionDescriptions(createOptionsDescription())
{
	for (int i=1; i<argc; ++i)
		mArgs.push_back(argv[i]);

	init(helpCategory);
}

ProgramOptions::ProgramOptions(const std::vector<std::string>& args,
                               const std::string& helpCategory) :
		mOptionDescriptions(createOptionsDescription()), mArgs(args)
{
	init(helpCategory);
}

void ProgramOptions::init(const std::string& helpCategory)
{
	mEnablePositionalArguments = false;
	if (helpCategory.empty())
		mOptionDescriptions.add_options()("help,?", "Displays help");
	else {
		ProgramOptions::Description category = createOptionsDescription(helpCategory);
		category.add_options()("help,?", "Displays help");
		mOptionDescriptions.add(category);
	}
}

void ProgramOptions::getOptions(VariableMap& oMap) const
{
	// We have to handle positional arguments on our own,
	// otherwise boost::program_options also enables them even if we did
	// not specify any
	if(mEnablePositionalArguments)
		boost::program_options::store(boost::program_options::command_line_parser(mArgs).
				options(mOptionDescriptions).allow_unregistered().positional(mPositionalDescriptions).run(), oMap);
	else
		boost::program_options::store(boost::program_options::command_line_parser(mArgs).
				options(mOptionDescriptions).allow_unregistered().run(), oMap);

	boost::program_options::notify(oMap);
}

///////////////////////////////////////////////////////////////////////////////

} // namespace

