/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file LogTimer.C
 *    Implementation of LogTimer.h
 *
 * @author Tim Langner
 * @date   2010/07/08
 */

#include <error/LogTimer.h>

using namespace std;

namespace mira {

///////////////////////////////////////////////////////////////////////////////

LogTimer::LogTimer(SeverityLevel level,
	const char* name,
	const Time& time,
	const char* file, int line,
	const char* function,
	ThreadID threadID,
	const string& caption)
{
	mEnded = false;
	mCaption = string(name) + "[" + caption + "] ";
	mRecord.level = level;
	mRecord.time = time;
	mRecord.file = file;
	mRecord.line = line;
	mRecord.function = function;
	mRecord.threadID = threadID;
	MIRA_LOG_ATTR(level, time, file, line ,function, threadID) << mCaption << "started.";
}

LogTimer::~LogTimer()
{
	end();
}

Duration LogTimer::peek() const
{
	if ( !mEnded )
	{
		Time now = Time::now();
		Duration d = now - mRecord.time;
		MIRA_LOG_ATTR(mRecord.level, now, mRecord.file, mRecord.line ,mRecord.function, mRecord.threadID)
			<< mCaption << "peek at " << d << " after start";
		return d;
	}
	return Duration::invalid();
}

void LogTimer::end()
{
	if ( !mEnded )
	{
		Time now = Time::now();
		Duration d = now - mRecord.time;
		MIRA_LOG_ATTR(mRecord.level, now, mRecord.file, mRecord.line ,mRecord.function, mRecord.threadID)
			<< mCaption << "ended taking "	<< d;
		mEnded = true;
	}
}

///////////////////////////////////////////////////////////////////////////////

}
