/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 *  and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Redistribution and modification of this code is strictly prohibited.
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file Hexdump.h
 *    hexdump() method for printing binary content as hex dump into a stream.
 *
 * @author Erik Einhorn
 * @date   2012/05/03
 */

#ifndef _MIRA_HEXDUMP_H_
#define _MIRA_HEXDUMP_H_

#include <iostream>
#include <utils/Buffer.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * Prints a buffer as hexdump to the specified stream.
 * The buffer is specified by the pointer 'bytes' that points to the beginning
 * of the data buffer, and 'length' which specifies its length.
 */
MIRA_BASE_EXPORT void hexdump(std::ostream& stream, const uint8* bytes, std::size_t length);

/**
 * Prints a buffer as hexdump to the specified stream.
 */
template <typename T>
inline void hexdump(std::ostream& stream, const Buffer<T>& buffer) {
	hexdump(stream, (uint8*)buffer.data(), buffer.sizeInBytes());
}

///////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
