/*
 * Copyright (C) by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file RPCCallDefinition.h
 *    RPCCallDefinition for storing all information required to call a service method.
 *
 * @author Tim van der Grinten
 * @date   2020/04/27
 */

#ifndef _MIRA_RPCCALLDEFINITION_H_
#define _MIRA_RPCCALLDEFINITION_H_

#include <string>

#include <serialization/adapters/std/vector>

namespace mira {

//////////////////////////////////////////////////////////////////////////////
/**
 * @ingroup RPCModule
 *
 * Stores info required to call an RPC method - service name, method name, arguments.
 */
struct RPCCallDefinition
{
	RPCCallDefinition() {}
	RPCCallDefinition(const std::string& iService, const std::string& iMethod,
	                  const std::string& iParams = "")
		: service(iService), method(iMethod), params(iParams)
	{
	}

public:

	template <typename Reflector>
	void reflect(Reflector& r)
	{
		r.member("Service", service, "Service name");
		r.member("Method", method, "Method name");
		r.member("Params", params, "Parameter list as JSON array", "");
	}

	/// The service's name
	std::string service;

	/// The method's name
	std::string method;

	/// The parameters as JSON array (note: without enclosing [])
	std::string params;
};

typedef std::vector<RPCCallDefinition> RPCCallDefinitions;

//////////////////////////////////////////////////////////////////////////////

} // namespace

#endif /* _MIRA_RPCCALLDEFINITION_H_ */
