/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file ThreadMonitorExample.C
 *    Example how to use the ThreadMonitor class
 *
 * @author Christian Martin
 */

#include <error/LogTxtStreamSink.h>

#include <thread/ThreadMonitor.h>

using namespace std;
using namespace mira;

///////////////////////////////////////////////////////////////////////////////

void printThreadMonitorList()
{
	ThreadMonitor::ThreadInfoVector tInfos =
			                   ThreadMonitor::instance().getThreadInformation();
	for(size_t i = 0; i < tInfos.size(); i++) {
		cout << "  '" << tInfos[i].name << "'" << endl;
		cout << "    CreateTime = " << tInfos[i].create_time.toLocal() << endl;
		cout << "    UserTime   = " << tInfos[i].user_time << endl;
		cout << "    KernelTime = " << tInfos[i].kernel_time << endl;
	}
}

///////////////////////////////////////////////////////////////////////////////

void evilThread()
{
	ThreadMonitor::instance().addThisThread("EvilThread");
	while (!boost::this_thread::interruption_requested())
		;

	// the following call will remove this thread, however this will also be
	// done automatically by the ThreadMonitor
	//ThreadMonitor::instance().removeThisThread();
}

///////////////////////////////////////////////////////////////////////////////

int main(int pArgc, char* pArgv[])
{
	MIRA_LOGGER.registerSink(LogTxtStreamSink(std::cout));
	MIRA_LOGGER.setSeverityLevel(DEBUG);

	cout << "Threads after application start:" << endl;
	printThreadMonitorList();

	cout << "Starting evilThread..." << endl;
	boost::thread tEvilThread(boost::bind(&evilThread));
	printThreadMonitorList();

	cout << "Sleep 5 seconds..." << endl;
	MIRA_SLEEP(5000);

	cout << "Threads after 5 seconds:" << endl;
	printThreadMonitorList();

	cout << "Interrupt and join evilThread..." << endl;
	tEvilThread.interrupt();
	tEvilThread.join();

	cout << "Threads after evilThread died:" << endl;
	printThreadMonitorList();

	return(0);
}
