/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

#include <serialization/XMLSerializer.h>

using namespace mira;
using namespace std;

class MyClass {
public:
	template<typename Reflector>
	void reflect(Reflector& r)
	{
		r.member("value",val,"");
	}

	int val;
};

class PointerConflict
{
public:
	PointerConflict()
	{
		mObject.val = 1234;
		mPtr = &mObject;
	}

    template<typename Reflector>
    void reflect(Reflector& r)
    {
    	// here the object is serialized AFTER the pointer to it --> conflict!!!
    	r.member("ptr",mPtr,"");
        r.member("object", mObject,"");

        // When reaching mPtr the serialization framework will serialize
        // the full object where the pointer points to.
        // When it reaches mObject (the object, the pointer points to)
        // it will throw an XIO exception, since the object was serialized
        // by the pointer already (a pointer reference is not
        // possible here)
    }

    MyClass* mPtr;
    MyClass  mObject;

};


class PointerNoConflict
{
public:
	PointerNoConflict()
	{
		mObject.val = 1234;
		mPtr = &mObject;
	}

    template<typename Reflector>
    void reflect(Reflector& r)
    {
    	// here the object is serialized BEFORE the pointer to it
        r.member("object", mObject,"");
        r.member("ptr",mPtr,"");

        // When reaching mObject the serialization framework will serialize
        // the full object.
        // When it reaches mPtr which points to mObject it will not
        // serialize the full object again, instead (a pointer reference is
        // used here)
    }

    MyClass* mPtr;
    MyClass  mObject;

};

int main()
{

    try {
    	cout << "serializing PointerConflict" << endl;

    	XMLDom xml;
   	    XMLSerializer s(xml);

    	PointerConflict c;
    	s.serialize("myobject", c);

    	cout << "serialized class successfully" << endl;

    } catch(Exception& ex) {
    	cout << "An exception has occured:" << endl;
    	cout << ex.what() << endl;
    }

    cout << endl;

    try {
    	cout << "serializing PointerNoConflict" << endl;

    	XMLDom xml;
   	    XMLSerializer s(xml);

    	PointerNoConflict c;
    	s.serialize("myobject", c);

    	cout << "serialized class successfully" << endl;

    } catch(Exception& ex) {
    	cout << "An exception has occured:" << endl;
    	cout << ex.what() << endl;
    }
    return 0;
}
