/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file LinesExample.C
 *    An example how to use lines.
 *
 * @author Jens Kessler
 * @date   2010/08/16
 */

#include <geometry/Geometry.h>
#include <iostream>

using namespace std;
using namespace mira;

int main()
{
	// create a point A
	Point3f A(0.0, 0.0, 0.0);

	// create 2 lines L1 and L2
	Line3f L1(Point3f(0.0, 1.0, 1.0), Point3f(1.0, 1.0, 1.0));
	Line3f L2(Point3f(0.0, 0.0, 1.0), Point3f(2.0, 2.0, 1.0));

	// output the geometry
	cout << "Point A:" << A << endl;
	cout << "Line 1: start point" << L1.front() << endl;
	cout << "end point:" << L1.back() << endl;
	cout << "Line 2: start point" << L2.front() << endl;
	cout << "end point:" << L2.back() << endl;

	float d;

	// distance between point A and Line L1
	d = boost::geometry::distance(L1, A);
	cout << "Distance between Line 1 and Point A: " << d << endl;

	return 0;
}
