###############################################################################
# QuaZIP C++ Wrapper to access ZIP archives
###############################################################################

if (WIN32)
	if(FORCE_USE_QT4)
		MIRA_EXTERNAL_PROJECT(QuaZIP
			#URL http://netcologne.dl.sourceforge.net/project/quazip/quazip/0.7/quazip-0.7.zip
			URL http://www.mira-project.org/downloads/3rdparty/src/quazip-0.7.zip
		
			PREFIX       ${MIRA_EXTERNAL_DIR}/quazip
			STAMP_DIR    ${MIRA_EXTERNAL_DIR}/quazip/cmake
			TMP_DIR      ${MIRA_EXTERNAL_DIR}/quazip/cmake
			DOWNLOAD_DIR ${MIRA_EXTERNAL_DIR}/quazip
			SOURCE_DIR   ${MIRA_EXTERNAL_DIR}/quazip/quazip-0.7
			BINARY_DIR   ${MIRA_EXTERNAL_DIR}/quazip/build
			PATCH_COMMAND patch -p1 --binary < ${CMAKE_CURRENT_LIST_DIR}/quazip_force_qt4.patch
			CMAKE_ARGS   -D CMAKE_INSTALL_PREFIX=${MIRA_EXTERNAL_DIR}/quazip -DCMAKE_TOOLCHAIN_FILE=${CMAKE_TOOLCHAIN_FILE} -DZLIB_INCLUDE_DIRS=${ZLIB_INCLUDE_DIRS}
		)
	else()
		MIRA_EXTERNAL_PROJECT(QuaZIP
			#URL http://netcologne.dl.sourceforge.net/project/quazip/quazip/0.7/quazip-0.7.zip
			URL http://www.mira-project.org/downloads/3rdparty/src/quazip-0.7.zip
		
			PREFIX       ${MIRA_EXTERNAL_DIR}/quazip
			STAMP_DIR    ${MIRA_EXTERNAL_DIR}/quazip/cmake
			TMP_DIR      ${MIRA_EXTERNAL_DIR}/quazip/cmake
			DOWNLOAD_DIR ${MIRA_EXTERNAL_DIR}/quazip
			SOURCE_DIR   ${MIRA_EXTERNAL_DIR}/quazip/quazip-0.7
			BINARY_DIR   ${MIRA_EXTERNAL_DIR}/quazip/build
			PATCH_COMMAND patch -p1 --binary < ${CMAKE_CURRENT_LIST_DIR}/quazip.patch
			CMAKE_ARGS   -D CMAKE_INSTALL_PREFIX=${MIRA_EXTERNAL_DIR}/quazip -DCMAKE_TOOLCHAIN_FILE=${CMAKE_TOOLCHAIN_FILE} -DZLIB_INCLUDE_DIRS=${ZLIB_INCLUDE_DIRS}
		)
	endif()
else()
	if(FORCE_USE_QT4)
		MIRA_EXTERNAL_PROJECT(QuaZIP
			#URL http://netcologne.dl.sourceforge.net/project/quazip/quazip/0.7/quazip-0.7.zip
			URL http://www.mira-project.org/downloads/3rdparty/src/quazip-0.7.zip
		
			PREFIX       ${MIRA_EXTERNAL_DIR}/quazip
			STAMP_DIR    ${MIRA_EXTERNAL_DIR}/quazip/cmake
			TMP_DIR      ${MIRA_EXTERNAL_DIR}/quazip/cmake
			DOWNLOAD_DIR ${MIRA_EXTERNAL_DIR}/quazip
			SOURCE_DIR   ${MIRA_EXTERNAL_DIR}/quazip/quazip-0.7
			BINARY_DIR   ${MIRA_EXTERNAL_DIR}/quazip/build
			PATCH_COMMAND ${MIRA_ROOT_DIR}/scripts/mirapatch.sh ${CMAKE_CURRENT_LIST_DIR}/quazip_force_qt4.patch ${MIRA_EXTERNAL_DIR}/quazip -p1 --binary
			CMAKE_ARGS   -D CMAKE_INSTALL_PREFIX=${MIRA_EXTERNAL_DIR}/quazip -DCMAKE_TOOLCHAIN_FILE=${CMAKE_TOOLCHAIN_FILE} -DZLIB_INCLUDE_DIRS=${ZLIB_INCLUDE_DIRS}
		)
	else()
		MIRA_EXTERNAL_PROJECT(QuaZIP
			#URL http://netcologne.dl.sourceforge.net/project/quazip/quazip/0.7/quazip-0.7.zip
			URL http://www.mira-project.org/downloads/3rdparty/src/quazip-0.7.zip
		
			PREFIX       ${MIRA_EXTERNAL_DIR}/quazip
			STAMP_DIR    ${MIRA_EXTERNAL_DIR}/quazip/cmake
			TMP_DIR      ${MIRA_EXTERNAL_DIR}/quazip/cmake
			DOWNLOAD_DIR ${MIRA_EXTERNAL_DIR}/quazip
			SOURCE_DIR   ${MIRA_EXTERNAL_DIR}/quazip/quazip-0.7
			BINARY_DIR   ${MIRA_EXTERNAL_DIR}/quazip/build
			PATCH_COMMAND ${MIRA_ROOT_DIR}/scripts/mirapatch.sh ${CMAKE_CURRENT_LIST_DIR}/quazip.patch ${MIRA_EXTERNAL_DIR}/quazip -p1 --binary
			CMAKE_ARGS   -D CMAKE_INSTALL_PREFIX=${MIRA_EXTERNAL_DIR}/quazip -DCMAKE_TOOLCHAIN_FILE=${CMAKE_TOOLCHAIN_FILE} -DZLIB_INCLUDE_DIRS=${ZLIB_INCLUDE_DIRS}
		)
	endif()
endif()

IF(WIN32)
	SET(QUAZIP_LIBRARY "quazip.lib")
ELSE()
	SET(QUAZIP_LIBRARY "libquazip.so")
ENDIF()

###############################################################################

# Set the include dir
SET(QUAZIP_INCLUDE_DIRS "${MIRA_EXTERNAL_DIR}/quazip/include" ${ZLIB_INCLUDE_DIRS})
SET(QUAZIP_LIBRARY_DIRS "${MIRA_EXTERNAL_DIR}/quazip/lib")

IF (CMAKE_VERBOSE_MAKEFILE)
	MESSAGE(STATUS "QuaZIP")
	MESSAGE(STATUS "   incdir = " ${QUAZIP_INCLUDE_DIRS})
ENDIF (CMAKE_VERBOSE_MAKEFILE)

###############################################################################

IF(WIN32)
	MIRA_DIST_LIBRARY_EX(QuaZIP ${MIRA_EXTERNAL_DIR}/quazip/lib/quazip.dll)

	MIRA_INSTALL(
		FILES ${MIRA_EXTERNAL_DIR}/quazip/lib/quazip.dll
		DESTINATION bin
		PACKAGE     MIRAPackage
	)
ELSE()
	MIRA_INSTALL(
		DIRECTORY ${MIRA_EXTERNAL_DIR}/quazip/lib
		DESTINATION .
		PACKAGE     MIRAPackage
		FILES_MATCHING
		PATTERN "*.so*"
		PATTERN "*.lib"
	)
ENDIF()
