/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file VisualizationPlotCurveView.C
 *    .
 *
 * @author Christian Vollmer
 * @date   2013/06/04
 */

#include <qwt_global.h>

#if (QWT_VERSION >= 0x060000)

#include <views/VisualizationPlotBarChartView.h>

#include <visualization/plot/VisualizationPlotBarChartJSON.h>

namespace mira {

//////////////////////////////////////////////////////////////////////////////

class DefaultPlotBarChartVisualization : public VisualizationPlotBarChartJSON<void>
{
MIRA_META_OBJECT(DefaultPlotBarChartVisualization,
                 ("Name", "DefaultVisualization")
                 ("Description", "Plots (elements of) data based on its JSON representation")
                 ("Category", "General"))

public:

	typedef VisualizationPlotBarChartJSON<void> Base;

	DefaultPlotBarChartVisualization() : Base("Channel") {}
};

///////////////////////////////////////////////////////////////////////////////

VisualizationPlotBarChartView::VisualizationPlotBarChartView()
{
}

const Class& VisualizationPlotBarChartView::supportedVisualizationClass() const
{
	return VisualizationPlotBarChart::CLASS();
}

const Class& VisualizationPlotBarChartView::defaultVisualizationClass() const
{
	return DefaultPlotBarChartVisualization::CLASS();
}

void VisualizationPlotBarChartView::populateDefaultVisualizations()
{
	createDefaultVisualization("mira::PlotBarChartGridVisualization", "Grid");
}

}

///////////////////////////////////////////////////////////////////////////////

MIRA_CLASS_SERIALIZATION( mira::VisualizationPlotBarChartView, mira::VisualizationViewTransformable);
MIRA_CLASS_SERIALIZATION( mira::DefaultPlotBarChartVisualization, mira::VisualizationPlotBarChart);

///////////////////////////////////////////////////////////////////////////////

#endif
