/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file BasicGoalTool.C
 *    Tool plugin for miracenter to send a robot to a goal using the 
 *    INavigation service interface.
 *
 * @author Erik Einhorn
 * @date   2011/07/02
 */

#include <gui/3d/BasicGoalTool.h>

namespace mira { namespace navigation {

///////////////////////////////////////////////////////////////////////////////

QIcon BasicGoalTool::getIcon() {
	QPixmap pixmap(":/icons/ToolGoal.png");
	return QIcon(pixmap);
}

void BasicGoalTool::onNewPose(const PoseCov2& pose)
{
	std::string service = mNavigationService;
	// user did not provide a service -> search for interface
	if (service.empty())
	{
		auto l = queryServicesForInterface("INavigation");
		if (!l.empty())
			service = l.front();
	}
	if (!service.empty()) {
		json::Value v;
		json::read(mBaseTask, v);
		JSONDeserializer js(v);
		TaskPtr task;
		js.deserialize(task);
		task->addSubTask(SubTaskPtr(new PositionTask(pose.t, pose.cov(0,0), pose.cov(0,0)+0.10f,
		                                             getSite()->getFixedFrame())));
		task->addSubTask(SubTaskPtr(new OrientationTask(pose.phi(), pose.cov(2,2),
		                                                getSite()->getFixedFrame())));
		auto result = callService<void>(service, "setTask", task);
		result.timedWait(Duration::seconds(10));
		result.get(); // will cause exception if something went wrong
	}
}

void BasicGoalTool::onMousePressed(QMouseEvent* e)
{
	PoseTool::onMousePressed(e);

	if (e->button() != Qt::RightButton)
		return;

	std::string service = mNavigationService;
	// user did not provide a service -> search for interface
	if (service.empty())
	{
		auto l = queryServicesForInterface("INavigation");
		if (!l.empty())
			service = l.front();
	}
	if (!service.empty()) {
		auto result = callService<void>(service, "setTask", TaskPtr(new Task));
		result.timedWait(Duration::seconds(10));
		result.get(); // will cause exception if something went wrong
	}
}

///////////////////////////////////////////////////////////////////////////////

}}

MIRA_CLASS_SERIALIZATION(mira::navigation::BasicGoalTool, mira::VisualizationTool3D)
