/*
 * Copyright (C) by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file ImgCodecTest.C
 *    Test cases for serialization of Img class with codec
 *
 * @author Christof Schröter
 * @date   2020/07/13
 */

#include <boost/test/unit_test.hpp>

#include <serialization/BinarySerializer.h>
#include <image/Img.h>

#include <codec/JpegCodec.h>
#include <codec/PngCodec.h>

using namespace mira;
using namespace mira::codec;

///////////////////////////////////////////////////////////////////////////////

/**
 *    *---------------*
 *    | *----*        |
 *    |_|____|___ line|
 *    | |    |        |
 *    | *----*img2    |
 *    *---------------* img 100x100
 */

void testImgCodec(int w, int h, BinarySerializerCodecPtr codec, bool equal = true) {
	Img8U3 img(w,h);

	Buffer<uint8> buffer;
	BinaryBufferSerializer bos(&buffer);
	bos.registerCodec(codec);

	//draw line
	cv::line((cv::Mat&)img, Point2i(10,50),Point2i(90,50), Color::Red);

	bos.serialize(img);

	BinaryBufferDeserializer bis(&buffer);
	Img8U3 imgd;
	bis.deserialize(imgd);

	if (equal) {
		BOOST_CHECK(img == imgd);
	} else {
		BOOST_CHECK(img.size() == imgd.size());
		BOOST_CHECK(img.depth() == imgd.depth());
	}

}

BOOST_AUTO_TEST_CASE( ImgCodecTest ) {
	testImgCodec(100, 100, BinarySerializerCodecPtr(new PngCodec(3)), true);
	testImgCodec(100, 100, BinarySerializerCodecPtr(new PngCodec(9)), true);
	testImgCodec(100, 100, BinarySerializerCodecPtr(new JpegCodec(50)), false);
	testImgCodec(100, 100, BinarySerializerCodecPtr(new JpegCodec(99)), false);

	testImgCodec(0, 0, BinarySerializerCodecPtr(new PngCodec(9)), true);
	testImgCodec(0, 0, BinarySerializerCodecPtr(new JpegCodec(99)), true);
}
