/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file PngCodec.h
 *    Codec for encoding and decoding images as PNG.
 *
 * @author Erik Einhorn
 * @date   2011/10/03
 */

#ifndef _MIRA_PNGCODEC_H_
#define _MIRA_PNGCODEC_H_

#include <serialization/BinarySerializerCodec.h>

#include <codec/CommonCodecsExports.h>

namespace mira { namespace codec {

///////////////////////////////////////////////////////////////////////////////

/**
 * PNG Codec class that can be used together with a BinarySerializer
 * to encode images as PNG.
 */
class MIRA_COMMONCODECS_EXPORT PngCodec : public BinarySerializerCodec
{
MIRA_META_OBJECT(PngCodec,
		("FOURCC",      "PNG ")
		("Name",        "Png")
		("Description", "Lossless PNG image compression")
		("Category"   , "Image"))
public:

	/**
	 * Creates a PngCodec with the specified
	 * compression mode: 0-9.
	 * 0: lowest but fastest compression, 9: best but slowest compression.
	 */
	PngCodec(int compression = 3) : mCompression(compression) {}

	template <typename Reflector>
	void reflect(Reflector &r)
	{
		r.property("Compression", mCompression, 
		           "Compression (0: lowest but fastest, 9: best but slowest)",
		           3);
	}

public:

	/// Implementation of BinarySerializerCodec
	virtual TypeId getSupportedTypeId() const;

protected:

	/// Implementation of BinarySerializerCodec
	virtual Buffer<uint8> encodeBuffer(TypedVoidConstPtr objectPtr);

	/// Implementation of BinarySerializerCodec
	virtual void decodeBuffer(const Buffer<uint8>& data, TypedVoidPtr ioObjectPtr);

private:

	int mCompression;
};

///////////////////////////////////////////////////////////////////////////////

}} // namespace

#endif
