#!/bin/bash

# determine mira path and set paths to tools (e.g. mirafindpkg)
_mirafindpkg=$MIRA_SCRIPT_DIR/../base/tools/mirafind/mirafindpkg

# _mira_split_path(arg)
# splits path in arg into its components:
#   <pkgname>:<reldir>
# and tries to obtain the full package path <pkgdir> for the package.
# The result is returned as array in _mira_split_path_var as (${pkgname} ${reldir} ${front} ${last} ${fullpath} ${pkgdir})
# Returns:
#  0 - no package name was included, no pkgdir available
#  1 - if package name was included but package was not found, no pkgdir available
#  2 - if package name was included in path and pkgdir is returned
function _mira_split_path
{
	local arg=$1
	_mira_split_path_var=()

	# split: <pkgname>:<reldir>
	local pkgname=${arg%%:*}
	local reldir=${arg#*:}

	# find position of the last / OR :
	local lastpos=`expr "${arg}" : '.*[/:]'`
	local front=${arg:0:$lastpos}
	local last=${arg:$lastpos}

	# get reldir up to the last / (
	lastpos=`expr "${reldir}" : '.*[/]'`
	reldir=${reldir:0:$lastpos}

	_mira_split_path_var[0]="${pkgname}"
	_mira_split_path_var[1]="${reldir}"
	_mira_split_path_var[2]="${front}"
	_mira_split_path_var[3]="${last}"
	if [[ $arg =~ : ]]; then
		# try to get the pkgdir
		local pkgdir=`bash $_mirafindpkg $pkgname -n 2> /dev/null`
		if [ -z ${pkgdir} ]; then
			return 1
		fi	
		_mira_split_path_var[4]="${pkgdir}/${reldir}/${last}"
		_mira_split_path_var[5]="${pkgdir}"
		return 2
	else
		#arg does not contain a :, hence package name is incomplete -> no pkgdir
		_mira_split_path_var[4]="${arg}" #return fullpath as it is
		return 0
	fi
}
