###############################################################################
# LibIConv
###############################################################################

IF(WIN32)
	# On Windows, download libiconv
	
	if(CMAKE_SIZEOF_VOID_P EQUAL 8)
		set(LIBICONV_URL "http://www.mira-project.org/downloads/3rdparty/bin-win64/iconv-1.14.0.win64.zip" )
	else()
		set(LIBICONV_URL "http://www.mira-project.org/downloads/3rdparty/bin-win32/iconv-1.9.2.win32.zip" )
	endif()

	MIRA_EXTERNAL_PROJECT(LibIconv
		URL ${LIBICONV_URL}

		PREFIX       ${MIRA_ROOT_DIR}/external/iconv
		STAMP_DIR    ${MIRA_ROOT_DIR}/external/iconv/cmake
		TMP_DIR      ${MIRA_ROOT_DIR}/external/iconv/cmake
		DOWNLOAD_DIR ${MIRA_ROOT_DIR}/external/iconv
		SOURCE_DIR   ${MIRA_ROOT_DIR}/external/iconv/iconv
		BINARY_DIR   ${MIRA_ROOT_DIR}/external/iconv/iconv
		CONFIGURE_COMMAND "" # no configure step
		BUILD_COMMAND     "" # no build step
		INSTALL_COMMAND   "" # no install step
	)

	SET(LIBICONV_INCLUDE_DIRS
		"${MIRA_ROOT_DIR}/external/iconv/iconv/include"
	)

	SET(LIBICONV_LIBRARY_DIRS
		"${MIRA_ROOT_DIR}/external/iconv/iconv/lib"
	)

	SET(LIBICONV_LIBRARIES
		"iconv"
	)

	MIRA_DIST_LIBRARY_EX(LibIconv ${MIRA_ROOT_DIR}/external/iconv/iconv/bin/iconv.dll)

	MIRA_INSTALL(
		DIRECTORY ${MIRA_ROOT_DIR}/external/iconv/iconv/include
		DESTINATION external/iconv/iconv
		PACKAGE external
		FILES_MATCHING
		PATTERN "*"
		PATTERN ".svn" EXCLUDE
	)

	MIRA_INSTALL(
		DIRECTORY ${MIRA_ROOT_DIR}/external/iconv/iconv/lib
		DESTINATION .
		PACKAGE external
		FILES_MATCHING
		PATTERN "*.lib"
	)

	MIRA_INSTALL(
		DIRECTORY ${MIRA_ROOT_DIR}/external/iconv/iconv/bin
		DESTINATION .
		PACKAGE external
		FILES_MATCHING
		PATTERN "*.dll"
	)

ELSE(WIN32)
	# On Linux, libiconv is part of the glibc-headers

	SET(LIBICONV_INCLUDE_DIRS "")
	SET(LIBICONV_LIBRARY_DIRS "")
	SET(LIBICONV_LIBRARIES    "")

ENDIF(WIN32)

###############################################################################

IF (CMAKE_VERBOSE_MAKEFILE)
	MESSAGE(STATUS "LIBICONV")
	MESSAGE(STATUS "   incdir = " ${LIBICONV_INCLUDE_DIRS})
	MESSAGE(STATUS "   libdir = " ${LIBICONV_LIBRARY_DIRS})
	MESSAGE(STATUS "   libs   = " ${LIBICONV_LIBRARIES})
ENDIF (CMAKE_VERBOSE_MAKEFILE)
