###############################################################################
# BOOST
###############################################################################

FIND_PACKAGE(Boost REQUIRED COMPONENTS 
             date_time
             filesystem
             iostreams
             program_options
             regex
             serialization
             system
             thread
             unit_test_framework
             wave)

IF(${Boost_MAJOR_VERSION} VERSION_LESS "1")
	MESSAGE(FATAL_ERROR "ERROR: Need at least Boost Version 1.44")
ENDIF()

IF(${Boost_MAJOR_VERSION} VERSION_EQUAL "1")
	IF(${Boost_MINOR_VERSION} VERSION_LESS "44")
		MESSAGE(FATAL_ERROR "ERROR: Need at least Boost Version 1.44")
	ENDIF()
ENDIF()

# force to use new boost filesystem version 3
ADD_DEFINITIONS(-DBOOST_FILESYSTEM_VERSION=3)

# those seem to be needed to avoid issues in PCHs with boost 1.71 and/or gcc 9.x
ADD_DEFINITIONS(-DBOOST_ALL_NO_LIB -DBOOST_ATOMIC_DYN_LINK -DBOOST_DATE_TIME_DYN_LINK -DBOOST_FILESYSTEM_DYN_LINK -DBOOST_IOSTREAMS_DYN_LINK -DBOOST_PROGRAM_OPTIONS_DYN_LINK -DBOOST_REGEX_DYN_LINK -DBOOST_SYSTEM_DYN_LINK -DBOOST_THREAD_DYN_LINK)

IF(WIN32)
	# Link Boost as DLLs rather than static library.
	ADD_DEFINITIONS(-DBOOST_ALL_DYN_LINK)
ENDIF(WIN32)

# prefer header only
ADD_DEFINITIONS(-DBOOST_FILESYSTEM_NO_LIB)
ADD_DEFINITIONS(-DBOOST_PROGRAM_OPTIONS_NO_LIB)
ADD_DEFINITIONS(-DBOOST_THREAD_NO_LIB)

###############################################################################

IF(WIN32)
	# On windows, the boost libraries will linked automatically
	SET(BOOST_DATE_TIME_LIBRARY           "")
	SET(BOOST_FILESYSTEM_LIBRARY          "")
	SET(BOOST_IOSTREAMS_LIBRARY           "")
	SET(BOOST_PROGRAM_OPTIONS_LIBRARY     "")
	SET(BOOST_REGEX_LIBRARY               "")
	SET(BOOST_SERIALIZATION_LIBRARY       "")
	SET(BOOST_SYSTEM_LIBRARY              "")
	SET(BOOST_THREAD_LIBRARY              "")
	SET(BOOST_UNIT_TEST_FRAMEWORK_LIBRARY "")
	SET(BOOST_WAVE_LIBRARY                "")
ELSE(WIN32)
	SET(BOOST_DATE_TIME_LIBRARY           ${Boost_DATE_TIME_LIBRARY})
	SET(BOOST_FILESYSTEM_LIBRARY          ${Boost_FILESYSTEM_LIBRARY})
	SET(BOOST_IOSTREAMS_LIBRARY           ${Boost_IOSTREAMS_LIBRARY})
	SET(BOOST_PROGRAM_OPTIONS_LIBRARY     ${Boost_PROGRAM_OPTIONS_LIBRARY})
	SET(BOOST_REGEX_LIBRARY               ${Boost_REGEX_LIBRARY})
	SET(BOOST_SERIALIZATION_LIBRARY       ${Boost_SERIALIZATION_LIBRARY})
	SET(BOOST_SYSTEM_LIBRARY              ${Boost_SYSTEM_LIBRARY})
	SET(BOOST_THREAD_LIBRARY              ${Boost_THREAD_LIBRARY})
	SET(BOOST_UNIT_TEST_FRAMEWORK_LIBRARY ${Boost_UNIT_TEST_FRAMEWORK_LIBRARY})
	SET(BOOST_WAVE_LIBRARY                ${Boost_WAVE_LIBRARY})
ENDIF(WIN32)

###############################################################################
# boost::geometry C++ Math Template-Library
###############################################################################

IF(${Boost_MINOR_VERSION} LESS 47)

MIRA_EXTERNAL_PROJECT(Geometry
	###########################################################################
	## change this link to use a different boost::geometry release
	SVN_REPOSITORY https://svn.boost.org/svn/boost/trunk/boost/geometry/
	SVN_REVISION -r76050
	###########################################################################
	PREFIX       ${MIRA_ROOT_DIR}/external/boost/boost/geometry
	STAMP_DIR    ${MIRA_ROOT_DIR}/external/boost/cmake
	TMP_DIR      ${MIRA_ROOT_DIR}/external/boost/cmake
	DOWNLOAD_DIR ${MIRA_ROOT_DIR}/external/boost/boost/geometry
	SOURCE_DIR   ${MIRA_ROOT_DIR}/external/boost/boost/geometry
	BINARY_DIR   ${MIRA_ROOT_DIR}/external/boost/boost/geometry
	UPDATE_COMMAND    "" # prevent svn update
	CONFIGURE_COMMAND "" # no configure step
	BUILD_COMMAND     "" # no build step
	INSTALL_COMMAND   "" # no install step
)

# Set the boost geometry include dir
SET(BOOST_GEOMETRY_INCLUDE_DIRS "${MIRA_ROOT_DIR}/external/boost")

IF (CMAKE_VERBOSE_MAKEFILE)
	MESSAGE(STATUS "Boost::geometry")
	MESSAGE(STATUS "   incdir = " ${BOOST_GEOMETRY_INCLUDE_DIRS})
ENDIF (CMAKE_VERBOSE_MAKEFILE)

###############################################################################

MIRA_INSTALL(
	DIRECTORY ${MIRA_ROOT_DIR}/external/boost/boost/geometry
	DESTINATION external/boost/boost
	PACKAGE external
	FILES_MATCHING
	PATTERN "*"
	PATTERN ".svn" EXCLUDE
)

ENDIF()
