###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
#
# Will obtain the relative path from absolute_source_path to
# absolute_dest_path 
#
# author: Erik Einhorn
#
###############################################################################

MACRO(RELPATH RPATHP SRCP DESTP)

	SET(SRC "${SRCP}")
	SET(DEST "${DESTP}")

	# for Linux
	STRING(REPLACE "//" ";" SRC "${SRC}")
	STRING(REPLACE "/"  ";" SRC "${SRC}")
	STRING(REPLACE "//" ";" DEST "${DEST}")
	STRING(REPLACE "/"  ";" DEST "${DEST}")

	# for Windows
	STRING(REPLACE "\\\\" ";" SRC "${SRC}")
	STRING(REPLACE "\\"   ";" SRC "${SRC}")
	STRING(REPLACE "\\\\" ";" DEST "${DEST}")
	STRING(REPLACE "\\"   ";" DEST "${DEST}")

	#MESSAGE("${SRC}")
	#MESSAGE("${DEST}")

	# put all src path items into SRC0 ... SRC[SRCCOUNT-1]
	SET(i 0)
	FOREACH(item ${SRC})
		SET("SRC${i}" "${item}")
		MATH(EXPR i ${i}+1)
	ENDFOREACH(item)
	SET(SRCCOUNT ${i})
	#MESSAGE(${SRCCOUNT})

	# put all dest path items into DEST0 ... DEST[DESTCOUNT-1]
	SET(i 0)
	FOREACH(item ${DEST})
		SET("DEST${i}" "${item}")
		MATH(EXPR i ${i}+1)
	ENDFOREACH(item)
	SET(DESTCOUNT ${i})
	#MESSAGE(${DESTCOUNT})

	# after the preprocessing the work starts here.
	# The source path is SRC0/SRC1/.../SRC[SRCCOUNT-1]
	# The dest path is DEST0/DEST1/.../DEST[DESTCOUNT-1]

	# 1. skip those parts of the paths which are idendical
	#SET(RPATH "./")
	SET(RPATH "")
	SET(level 0)
	WHILE ("${SRC${level}}" STREQUAL "${DEST${level}}" AND level LESS SRCCOUNT AND level LESS DESTCOUNT)
		MATH(EXPR level ${level}+1)
	ENDWHILE ()

	# 2. add a "../" for each part of the source path that is
	# not in dest (these are the directories we have
	# to move up till we reach the directory that we have
	# in common with dest)
	SET(i ${level})
	WHILE (i LESS SRCCOUNT)
		SET(RPATH "${RPATH}../")
		MATH(EXPR i ${i}+1)
	ENDWHILE (i LESS SRCCOUNT)

	# 3. finally add the subdirectories of dest that we
	# need to go into from the common path
	SET(i ${level})
	WHILE (i LESS DESTCOUNT)
		SET(RPATH "${RPATH}${DEST${i}}/")
		MATH(EXPR i ${i}+1)
	ENDWHILE (i LESS DESTCOUNT)

	#MESSAGE(${RPATH})

	SET(${RPATHP} ${RPATH})

ENDMACRO(RELPATH)
