###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
#
# Provides LIST_SUBDIRECTORIES macro.
#
# Usage:
#	LIST_SUBDIRECTORIES(TargetVar Directory Relative ExcludeList)
#		TargetVar:   target variable
#		Directory:   base directory for listing
#		Relative:    1 (return relative names)
#		             0 (return absolute names)
#		ExcludeList: List of directories, which should be excluded
#
# Parts of the following macro are taken from
#	http://www.cmake.org/pipermail/cmake/2008-February/020114.html
#
# Author: Christian Martin
#
###############################################################################

MACRO(LIST_SUBDIRECTORIES retval curdir return_relative exclude_list)

	FILE(GLOB sub-dir RELATIVE ${curdir} *)
	SET(list_of_dirs "")

	FOREACH(dir ${sub-dir})

		# Only use directories
		IF (IS_DIRECTORY ${curdir}/${dir})

			# Check, if the directory in in the exclude_list
			SET(exclude_this 0)
			FOREACH(exclude ${exclude_list})
				STRING(COMPARE EQUAL ${exclude} ${dir} ExcludeThisDir)
				IF (ExcludeThisDir EQUAL 1)
					SET(exclude_this 1)
				ENDIF()
			ENDFOREACH()

			# Check if ${dir} is a directory, but not ".svn"
			STRING(COMPARE NOTEQUAL ${dir} ".svn" IsNotSVNDir)
			IF ((${IsNotSVNDir} EQUAL 1) AND (${exclude_this} EQUAL 0))
				IF (${return_relative})
					SET(list_of_dirs ${list_of_dirs} ${dir})
				ELSE()
					SET(list_of_dirs ${list_of_dirs} ${curdir}/${dir})
				ENDIF()
			ENDIF()

		ENDIF()

	ENDFOREACH()

	SET(${retval} ${list_of_dirs})

ENDMACRO()
