/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file PropertyView.C
 *    Implementation of PropertyView.h.
 *
 * @author Erik Einhorn
 * @date   2010/12/14
 */

#include <views/PropertyView.h>

#include <QLabel>
#include <QMenu>
#include <QToolButton>

#include <serialization/Serialization.h>

#include <widgets/PropertyEditor.h>
#include <views/PropertyViewPage.h>
#include <rcp/ViewPartTitleBar.h>

///////////////////////////////////////////////////////////////////////////////

MIRA_CLASS_SERIALIZATION(mira::PropertyView, mira::PageViewPart);

namespace mira {

///////////////////////////////////////////////////////////////////////////////

PropertyView::PropertyView() :
	mDefaultPage(NULL)
{
	mHideFilterBarAct = getViewMenu()->addAction(tr("Hide filter bar automatically"));
	mHideFilterBarAct->setCheckable(true);
}

PropertyView::~PropertyView()
{
}

QWidget* PropertyView::createDefaultPage()
{
	if (mDefaultPage == NULL)
	{
		QLabel* label = new QLabel(this);
		label->setAlignment(Qt::AlignCenter);
		label->setText(tr("No properties available"));
		mDefaultPage = label;
	}
	return mDefaultPage;
}

QWidget* PropertyView::createPage(IWorkbenchPart* part)
{
	if(part->getClass().isDerivedFrom(&WorkbenchPart::CLASS()))
	{
		Object* obj = part->getAdapter(PropertyViewPage::CLASS());
		if(obj==NULL) // editor does not support a property view, so use default page
			return createDefaultPage();

		PropertyViewPage* page = dynamic_cast<PropertyViewPage*>(obj);
		assert(page!=NULL);

		page->mEditor->setAutoHideFilterBar(mHideFilterBarAct->isChecked());
		connect(mHideFilterBarAct, SIGNAL(toggled(bool)),
		        page->mEditor, SLOT(setAutoHideFilterBar(bool)));

		return page;
	}
	return NULL;
}

void PropertyView::viewActivated(IWorkbenchPart* part)
{
	// ignore our own activation
	if(part==this)
		return;

	PageViewPart::viewActivated(part);
}

///////////////////////////////////////////////////////////////////////////////

}
