/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file EditorPart.C
 *    Implementation of EditorPart.h.
 *
 * @author Erik Einhorn
 * @date   2010/12/01
 */

#include <rcp/EditorPart.h>

#include <QPainter>
#include <QCloseEvent>

#include <serialization/Serialization.h>

#include <rcp/EditorPartTitleBar.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

EditorPart::EditorPart() : mSite(NULL) {}

EditorPart::~EditorPart()
{
	emit editorDestroyed(this);
}

void EditorPart::init(IWorkbenchPartSite* site)
{
	mSite = site;
	QWidget* ctrl = createPartControl();

	ctrl->show();
	this->setWidget(ctrl);
}

QImage EditorPart::captureContent()
{
	QImage image(size(), QImage::Format_RGB32);
	QPainter painter(&image);
	render(&painter);
	return image;
}

IWorkbenchPartSite* EditorPart::getSite()
{
	return mSite;
}

QMenu* EditorPart::getViewMenu()
{
	assert(getTitleBar()!=NULL && getTitleBar()->getMenu()!=NULL);

	return getTitleBar()->getMenu();
}

void EditorPart::closeEvent(QCloseEvent* event)
{
	EditorPartWindow::closeEvent(event);

	if (event->isAccepted())
		emit editorClosed(this);
}

///////////////////////////////////////////////////////////////////////////////

}

MIRA_CLASS_SERIALIZATION( mira::EditorPart, mira::WorkbenchPart );
