/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file FlowLayout.h
 *    Layout, where the items are first laid out horizontally and then
 *    vertically when each line in the layout runs out of space.
 *
 * @author Erik Einhorn
 * @date   2012/12/11
 */

#ifndef MIRA_FLOWLAYOUT_H
#define MIRA_FLOWLAYOUT_H

#include <utility>
#include <QRect>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QWidgetItem>
#include <QStyle>

#include <widgets/GuiWidgetsExports.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * Layout, where the items are first laid out horizontally and then vertically
 * when each line in the layout runs out of space.
 * Can be used like any other layout, e.g. HBoxLayout, etc.
 */
class MIRA_GUI_WIDGETS_EXPORT FlowLayout : public QLayout
{
public:
	FlowLayout(QWidget* parent = NULL);
	~FlowLayout();

	/**
	 * Adds layout item with additional stretch factor (default=0).
	 * The stretch factor controls the Qt layout mechanism. Items with
	 * higher stretch factors have a higher priority to fill up the available
	 * space.
	 */
	void addItem(QLayoutItem *item, int stretch);

	// implementation of QLayout
	void addItem(QLayoutItem *item) {
		addItem(item,0);
	}

	Qt::Orientations expandingDirections() const;
	bool hasHeightForWidth() const;
	int heightForWidth(int) const;
	int count() const;
	QLayoutItem *itemAt(int index) const;
	QSize minimumSize() const;
	void setGeometry(const QRect &rect);
	QSize sizeHint() const;
	QLayoutItem *takeAt(int index);

private:

	void init();
	void clearLayouts();

	QList<std::pair<QLayoutItem*,int>> mItemList;
	QVBoxLayout* mVLayout;
	QList<QHBoxLayout*> mHLayouts;
};

///////////////////////////////////////////////////////////////////////////////

}

#endif
