/*
 * Copyright (C) by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file ServiceLevelTestCodec.C
 *
 * @author Christof Schröter
 * @date   2021/10/05
 */

#include "ServiceLevelTestCodec.h"

#include <image/Img.h>

#include <fw/Unit.h>

namespace mira { namespace test {

///////////////////////////////////////////////////////////////////////////////

int DummyCodec::sDecodeCount = 0;

TypeId DummyCodec::getSupportedTypeId() const { return typeId<cv::Mat>(); }

Buffer<uint8> DummyCodec::encodeBuffer(TypedVoidConstPtr objectPtr)
{
	const cv::Mat* image = objectPtr;
	if(image->depth()!=CV_8U || image->channels()!=1)
		MIRA_THROW(XIO, "DummyCodec supports unsigned 8bit images with one channel only");

	Buffer<uint8> buf;
	BinaryBufferOstream stream(&buf);

	// write the image size
	stream << uint32(image->cols);
	stream << uint32(image->rows);

	// write the raw image data
	for (int y=0; y<image->rows; ++y) {
		uint8* data = image->data + y*image->step;
		for (int x=0; x<image->cols; ++x) {
			stream << data[x];
		}
	}

	return std::move(buf);
}

void DummyCodec::decodeBuffer(const Buffer<uint8>& data, TypedVoidPtr ioObjectPtr)
{
	cv::Mat* image = ioObjectPtr;

	BinaryBufferIstream stream((Buffer<uint8>*)&data);

	// read the image size
	uint32 width,height;
	stream >> width;
	stream >> height;

	if(image->cols!=(int)width || image->rows!=(int)height ||
	   image->channels()!=1 || image->depth()!=CV_8U)
	{
		*image = cv::Mat(height, width, CV_8UC1);
	}

	// read the image data
	for (int y=0; y<image->rows; ++y) {
		uint8* data = image->data + y*image->step;
		for (int x=0; x<image->cols; ++x) {
			stream >> data[x];
		}
	}

	++sDecodeCount;
}

///////////////////////////////////////////////////////////////////////////////

}}

MIRA_CLASS_SERIALIZATION(mira::test::DummyCodec, mira::BinarySerializerCodec);

