/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file LazySingletonTest.C
 *    Test cases for LazySingleton.h.
 *
 * @author Tim Langner
 * @date   2010/07/06
 */

#include <iostream>
#include <boost/test/unit_test.hpp>
#include <boost/shared_ptr.hpp>
#include <utils/Singleton.h>

#include "LazySingletonTestLib1.h"
#include "LazySingletonTestLib2.h"

using namespace mira;
using namespace std;

///////////////////////////////////////////////////////////////////////////////

class A : public LazySingleton<A>
{
public:
	A() {
		std::cout << "Creating A" << std::endl;
		value = 1234;
	}

	~A() {
		std::cout << "Destroying A" << std::endl;
	}

	void foo() {
		std::cout << "Called A: " << value << std::endl;
	}

	int value;
};

BOOST_AUTO_TEST_CASE( testLazySingleton_Simple )
{
	BOOST_CHECK(&A::instance() != NULL);
	BOOST_CHECK_EQUAL(&A::instance(), &A::instance());
	BOOST_CHECK_EQUAL(A::instance().value, 1234);
	A::instance().foo();
}

///////////////////////////////////////////////////////////////////////////////

BOOST_AUTO_TEST_CASE( testLazySingleton_throughLibs )
{
	TestSingleton1::instance().print("use TestSingleton1 from main");

	TestSingleton2Int::instance().print("use TestSingleton2Int from main");
	TestSingleton2Float::instance().print("use TestSingleton2Float from main");

	SingletonUser1 tUser1;
	tUser1.useSingletons();

	SingletonUser2 tUser2;
	tUser2.useSingletons();

	void* tMain1  = TestSingleton1::instance().self();
	void* tMain2I = TestSingleton2Int::instance().self();
	void* tMain2F = TestSingleton2Float::instance().self();

	void* tLib1_1  = tUser1.getSingleton1();
	void* tLib1_2I = tUser1.getSingleton2Int();
	void* tLib1_2F = tUser1.getSingleton2Float();

	void* tLib2_1  = tUser2.getSingleton1();
	void* tLib2_2I = tUser2.getSingleton2Int();
	void* tLib2_2F = tUser2.getSingleton2Float();

	BOOST_CHECK((tMain1  == tLib1_1 ) && (tMain1  == tLib2_1 ));
	BOOST_CHECK((tMain2I == tLib1_2I) && (tMain2I == tLib2_2I));
	BOOST_CHECK((tMain2F == tLib1_2F) && (tMain2F == tLib2_2F));
}
