/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file PowerTest.C
 *    Test case
 *
 * @author Erik Einhorn
 * @date   2012/08/15
 */

#include <boost/test/unit_test.hpp>
#if BOOST_VERSION >= 107100
#include <boost/test/tools/floating_point_comparison.hpp>
#else
#include <boost/test/floating_point_comparison.hpp>
#endif

#include <math/Power.h>
#include <utils/PParam.h>

using namespace mira;

BOOST_AUTO_TEST_CASE( PowTest )
{
	BOOST_CHECK_EQUAL(pow<8>(2),256);
	BOOST_CHECK_EQUAL(pow<10>(2),1024);
	BOOST_CHECK_EQUAL(pow<3>(10),1000);

	BOOST_CHECK_CLOSE(pow<2>(0.5f),0.25f, 0.0001f);
	BOOST_CHECK_CLOSE(pow<3>(0.5f),0.125f, 0.0001f);
	BOOST_CHECK_CLOSE(pow<20>(1.1f),6.7275, 0.0001f);

	BOOST_CHECK_CLOSE(pow2(0.5f),0.25f, 0.0001f);
	BOOST_CHECK_CLOSE(pow3(0.5f),0.125f, 0.0001f);
}

BOOST_AUTO_TEST_CASE( TPowerTest )
{

	int v;

	v = TPower<2,8>::value;
	BOOST_CHECK_EQUAL(v,256);

	v = TPower<2,10>::value;
	BOOST_CHECK_EQUAL(v,1024);

	v = TPower<10,3>::value;
	BOOST_CHECK_EQUAL(v,1000);
}
