/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file DistanceLUTTest.C
 *    A test case for the class DistanceLUT.
 *
 * @author Erik Einhorn
 * @date   2010/12/06
 */

#include <boost/test/unit_test.hpp>
#include <iostream>

#include <geometry/DistanceLUT.h>

using namespace mira;
using namespace std;

// This test only tests if a LUT is constructable and outputs the
// content of the LUT
BOOST_AUTO_TEST_CASE( DistanceLUTTest )
{
	// define the LUT region
	DistanceLUT::instance();

	DistanceLUT::Region r =
		DistanceLUT::instance().getRegion(Point2f(0.5, 0),
		                                  Rect2i(-5, -5, 10, 10));
	// output the LUT
	DistanceLUT::iterator i  = r.getIterator(0,0);
	cout << "0,0 -> (" << i->minDist << ", " << i->maxDist << ")" << endl;
	for(DistanceLUT::iterator i=r.begin(0); i!=r.end(0); ++i)
	{
		cout << "(" << i->minDist << ", " << i->maxDist << ")" << endl;
	}

}
