/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file ParameterConstructorClasses.h
 *    $Test classes for test with parameter constructors$.
 *
 * @author Ronny Stricker
 * @date   2010/10/25
 */

#ifndef _MIRA_PARAMETERCONSTRUCTORCLASSES_H_
#define _MIRA_PARAMETERCONSTRUCTORCLASSES_H_

#include <factory/Factory.h>

namespace mira {

//////////////////////////////////////////////////////////////////////////////

/*
 * @brief Test class without public default constructor
 */
class ParamConst : virtual public Object {
	MIRA_OBJECT( ParamConst );

public:
	ParamConst( int number) { }

protected:
	ParamConst() {}
};

class ParamConstDerived : public ParamConst {
	MIRA_OBJECT( ParamConstDerived )
public:
	ParamConstDerived() : ParamConst( 5 ) {}
};

class ParamConstDerived2 : public ParamConstDerived {
	MIRA_OBJECT( ParamConstDerived2 )
public:
	ParamConstDerived2( int number ) : ParamConstDerived() {}
};

//////////////////////////////////////////////////////////////////////////////

/*
 * @brief Test class without default constructor and parameter constructor
 * with 1 parameter.
 */
class Const : public Object {
	MIRA_OBJECT( Const )

public:
	Const(int blub) : mInt(blub) {

	}

public:
	int mInt;
};

////////////////////////////////////////////////////////////////////////////////

/*
 * @brief Test class without default constructor and parameter constructor
 * with 2 parameters.
 */
class Const2 : public Object {
	MIRA_OBJECT( Const2 )

public:
	Const2(int blub, int blub2) : mInt(blub), mInt2(blub2) {

	}

public:
	int mInt;
	int mInt2;
};

////////////////////////////////////////////////////////////////////////////////

/*
 * @brief Test class without default constructor and parameter constructor
 * with 3 parameters.
 */
class Const3 : public Object {
	MIRA_OBJECT( Const3 )

public:
	Const3(int blub, int blub2, int blub3)
		: mInt(blub), mInt2(blub2), mInt3(blub3) {

	}

public:
	int mInt;
	int mInt2;
	int mInt3;
};

////////////////////////////////////////////////////////////////////////////////

/*
 * @brief Test class without default constructor and parameter constructor
 * with 4 parameters.
 */
class Const4 : public Object {
	MIRA_OBJECT( Const4 )

public:
	Const4(int blub, int blub2, int blub3, int blub4)
		: mInt(blub), mInt2(blub2), mInt3(blub3), mInt4(blub4) {

	}

public:
	int mInt;
	int mInt2;
	int mInt3;
	int mInt4;
};

////////////////////////////////////////////////////////////////////////////////

/*
 * @brief Abstract test class without default constructor and parameter
 * constructor with 2 parameter.
 */
class ConstAbstract : public Object {
	MIRA_OBJECT( ConstAbstract )

public:
	ConstAbstract(int blub, int blub2) : mInt(blub), mInt2(blub2) {
	}

	virtual void test() = 0;

public:
	int mInt;
	int mInt2;
};

////////////////////////////////////////////////////////////////////////////////


} // namespace

namespace subspace {

/*
 * @brief Test class without default constructor and parameter
 * constructor with 2 parameter which is derived from abstrac class.
 */
class ConstDerived : public mira::ConstAbstract {
	MIRA_OBJECT( ConstDerived )

public:
	ConstDerived(int blub, int blub2) : ConstAbstract( blub, blub2 ) {
	}

	void test() {
		mInt = 5;
	}
};

} // namespace

////////////////////////////////////////////////////////////////////////////////

MIRA_CLASS_REGISTER( mira::ParamConst, mira::Object );
MIRA_NO_PUBLIC_DEFAULT_CONSTRUCTOR( mira::ParamConst )
MIRA_OBJECT_CONSTRUCTOR1( mira::ParamConst, int );

MIRA_CLASS_REGISTER( mira::ParamConstDerived, mira::ParamConst );

MIRA_CLASS_REGISTER( mira::ParamConstDerived2, mira::ParamConstDerived );
MIRA_NO_PUBLIC_DEFAULT_CONSTRUCTOR( mira::ParamConstDerived2 )
MIRA_OBJECT_CONSTRUCTOR1( mira::ParamConstDerived2, int );

MIRA_CLASS_REGISTER( mira::Const, mira::Object );
MIRA_NO_PUBLIC_DEFAULT_CONSTRUCTOR( mira::Const )
MIRA_OBJECT_CONSTRUCTOR1( mira::Const, int );

MIRA_CLASS_REGISTER( mira::Const2, mira::Object );
MIRA_NO_PUBLIC_DEFAULT_CONSTRUCTOR( mira::Const2 )
MIRA_OBJECT_CONSTRUCTOR2( mira::Const2, int,int );

MIRA_CLASS_REGISTER( mira::Const3, mira::Object );
MIRA_NO_PUBLIC_DEFAULT_CONSTRUCTOR( mira::Const3 )
MIRA_OBJECT_CONSTRUCTOR3( mira::Const3, int,int,int );

MIRA_CLASS_REGISTER( mira::Const4, mira::Object );
MIRA_NO_PUBLIC_DEFAULT_CONSTRUCTOR( mira::Const4 )
MIRA_OBJECT_CONSTRUCTOR4( mira::Const4, int,int,int,int );

MIRA_CLASS_REGISTER( mira::ConstAbstract, mira::Object );
MIRA_NO_PUBLIC_DEFAULT_CONSTRUCTOR( mira::ConstAbstract )

MIRA_CLASS_REGISTER( subspace::ConstDerived, mira::ConstAbstract );
MIRA_NO_PUBLIC_DEFAULT_CONSTRUCTOR( subspace::ConstDerived )
MIRA_OBJECT_CONSTRUCTOR2( subspace::ConstDerived, int, int )

#endif /* _MIRA_PARAMETERCONSTRUCTORCLASSES_H_ */

