/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file Circle.h
 *    A class representing a circle.
 *
 * @author Erik Einhorn
 * @date   2012/02/09
 */

#ifndef _MIRA_CIRCLE_H_
#define _MIRA_CIRCLE_H_

#include <geometry/Point.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * Represents a circle with a center and a radius.
 */
template <typename T>
class Circle
{
public:
	typedef Point<T,2> PointType;

public:

	/// Creates an uninitialized circle segment
	Circle() :
		radius(0)
	{}

	/// Creates a circle with given center and radius
	Circle(const PointType& c, T r) :
		center(c),
		radius(r)
	{}

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		r.member("Center", center, "The center of the circle");
		r.member("Radius", radius, "The radius of the circle");
	}

	PointType center; ///< The center of the circle
	T         radius; ///< The radius of the circle
};

typedef Circle<int>    Circlei; ///< A integer circle.
typedef Circle<float>  Circlef; ///< A float circle.
typedef Circle<double> Circled; ///< A double circle.

///////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
