/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file TemplateClass.h
 *    $Definition of the template class objects which enables the factory to
 *    work with template classes$.
 *
 * @author Ronny Stricker
 * @date   2011/02/28
 */

#ifndef _MIRA_TEMPLATECLASS_H_
#define _MIRA_TEMPLATECLASS_H_

#include <factory/TClass.h>

namespace mira {

//////////////////////////////////////////////////////////////////////////////

/**
 * @brief The TemplateClass object is the implementation of the Class class for
 * template classes. The main difference between the TClass and the Template
 * Class is that the TemplateClass calls template functions with the specialized
 * template type to obtain name and identifier of the class.
 */
template<typename CLASS>
class TemplateClass : public TClass<CLASS>
{
public:
	/**
	 * @brief The constructor
	 * The constructor calls the addMetaInfo() function of the CLASS object
	 * to add the meta informations to the mMetaInfo map.
	 */
	TemplateClass( std::string const& identifier,
	               std::string const& name,
	               bool libLoaded );

	/**
	 * @brief Return identifier for the class.
	 * The identifiers probably contains the namespace of the class.
	 */
	virtual std::string const& getIdentifier() const;

	/**
	 * @brief Return name of the class.
	 * The name will not contain any informations about the class namespace
	 * (if the macro for automatic extraction of the name has been used).
	 * Otherwise the function simply returns the name given in the object macro.
	 */
	virtual std::string const& getName() const;
};

//////////////////////////////////////////////////////////////////////////////

template<typename CLASS>
inline TemplateClass<CLASS>::TemplateClass( std::string const& identifier,
                                            std::string const& name,
                                            bool libLoaded ) :
	TClass<CLASS>( identifier, name, libLoaded )
{
	// when we are going to be destructed, our template specialization for the
	// getIdentifier function will not be available any longer, we should
	// inform the Class class about our real name...
	Class::mIdentifier = getIdentifier();
}

//////////////////////////////////////////////////////////////////////////////

} // namespace

#endif /* _MIRA_TEMPLATECLASS_H_ */

