###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
#
# Provides PROVIDE_TEST_SUPPLEMENT macro that copies required test files into
# the directory of the binary (where the test binary is executed).
#
# Usage:
#   PROVIDE_TEST_SUPPLEMENT(TARGET file_that_is_needed_for_test)
#
# Author: Erik Einhorn
#
###############################################################################

MACRO(PROVIDE_TEST_SUPPLEMENT target file)

	SET(fullFilePath ${CMAKE_CURRENT_SOURCE_DIR}/${file})

	# get the full path to the generated target
	GET_TARGET_PROPERTY(targetPath ${target} LOCATION )
	GET_FILENAME_COMPONENT(targetDir ${targetPath} PATH)

	# for debugging:
	#MESSAGE("fullFilePath source = " ${fullFilePath})
	#MESSAGE("fullTargetPath = " ${targetPath})
	#MESSAGE("targetDir = " ${targetDir})

	ADD_CUSTOM_COMMAND(TARGET ${target} POST_BUILD
		#COMMAND ${CMAKE_COMMAND} -E remove ${installPath}
		COMMAND ${CMAKE_COMMAND} -E copy ${fullFilePath} ${targetDir}
	)

ENDMACRO(PROVIDE_TEST_SUPPLEMENT)

###############################################################################
