/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file BugTests.h
 *
 * @author Erik Einhorn
 */

#include <iostream>
#include <serialization/XMLSerializer.h>
#include <serialization/BinarySerializer.h>
#include <serialization/Serialization.h>
#include <serialization/adapters/std/vector>
#include <serialization/adapters/std/list>

using namespace std;
using namespace mira;

//////////////////////////////////////////////////////////////////////////////

#define PREAMBLE                            \
	XMLDom xml;                             \
	XMLSerializer s1(xml);                  \
	XMLDeserializer d1(xml);                \
	Buffer<uint8> buffer;                   \
	BinaryBufferSerializer s2(&buffer);     \
	BinaryBufferDeserializer d2(&buffer);

//////////////////////////////////////////////////////////////////////////////
// #47
class Issue47a : virtual public Object
{
MIRA_OBJECT(Issue47a)
public:
	Issue47a()     : val1(0)   {}
	Issue47a(bool) : val1(123) {}
	int val1;

	template<typename Reflector>
	void reflect(Reflector& r) {
		r.member("val1", val1, "");
	}
};

class Issue47b : virtual public Object
{
MIRA_OBJECT(Issue47b)
public:
	Issue47b()     : val2(0)   {}
	Issue47b(bool) : val2(456) {}
	int val2;

	template<typename Reflector>
	void reflect(Reflector& r) {
		r.member("val2", val2, "");
	}

};

class Issue47c
{
public:
	float dummy[21];
};


class Issue47 : private Issue47c, virtual public Issue47a, virtual public Issue47b
{
MIRA_OBJECT(Issue47)
public:
	Issue47() {}
	Issue47(bool) : Issue47a(true), Issue47b(true) {}
	template<typename Reflector>
	void reflect(Reflector& r) {
		MIRA_REFLECT_BASE(r, Issue47a);
		MIRA_REFLECT_BASE(r, Issue47b);
	}
};

MIRA_CLASS_SERIALIZATION(Issue47a, Object)
MIRA_CLASS_SERIALIZATION(Issue47b, Object)
MIRA_CLASS_SERIALIZATION(Issue47, Issue47a, Issue47b)

void test47()
{
	PREAMBLE
	Issue47 issue47_1(true);
	s1.serialize("Issue60", issue47_1);


	Issue47 issue47_2;
	cout << issue47_2.val1 << endl;
	cout << issue47_2.val2 << endl;

	d1.deserialize("Issue60", issue47_2);
	//s2.serialize(issue47);
	//d2.deserialize(issue47);
	cout << issue47_2.val1 << endl;
	cout << issue47_2.val2 << endl;
}


//////////////////////////////////////////////////////////////////////////////
// #60
class Issue60
{
public:

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		r.member("MyStringMember", mStringMember1, "Comment", "DefaultValue");
		r.property("MyStringMember", mStringMember2, "Comment", "DefaultValue");
	}

public:
	std::string mStringMember1;
	std::string mStringMember2;

};
void test60()
{
	PREAMBLE
	Issue60 issue60;
	s1.serialize("Issue60", issue60);
	d1.deserialize("Issue60", issue60);
	s2.serialize(issue60);
	d2.deserialize(issue60);
}

//////////////////////////////////////////////////////////////////////////////
// #67
void test67()
{
	PREAMBLE
	vector<int> v;
	v.push_back(1);
	v.push_back(2);
	s1.serialize("Issue67", v);
	d1.deserialize("Issue67", v);
	s2.serialize(v);
	d2.deserialize(v);
}

//////////////////////////////////////////////////////////////////////////////
// #253

class Test253
{
public:
	template<typename Reflector>
	void reflect(Reflector& r)
	{
		r.member("List", list, "");
	}

	std::list<std::string> list;
};

void test253()
{
	PREAMBLE
	Test253 t;
	t.list.push_back("Test");
	t.list.push_back("Test2");
	s1.serialize("Issue253", t);
	d1.deserialize("Issue253", t);
	s2.serialize(t);
	d2.deserialize(t);
}

//////////////////////////////////////////////////////////////////////////////

int main()
{
	test47();
	test60();
	test67();
	test253();
	return 0;
}
