/*
 * Copyright (C) by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file IsCopyAssignable.h
 *    Type trait to check if a class is copy assignable.
 *
 * @author Christof Schröter
 * @date   2021/02/24
 */

#ifndef _MIRA_ISCOPYASSIGNABLE_H_
#define _MIRA_ISCOPYASSIGNABLE_H_

#include <type_traits>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * Type trait that evaluates to true if a type is copy assignable, false otherwise.
 *
 * This can be used (e.g. by the serialization framework) to instantiate code that
 * does not require assignment at compile time, ensuring successful compilation
 * (some operations may depend on assignment and thus fail at runtime when executed,
 * e.g. throw an exception).
 *
 * By default this trait inherits from std::is_copy_assignable<>. In contrast to
 * std::is_copy_assignable<>, it is meant to be explicitly specialized for used
 * types for which the validity of an assignment operator can not be properly
 * checked, e.g. std::vector<boost::noncopyable>.
 */

template <typename T>
class IsCopyAssignable : public std::is_copy_assignable<T> {};

///////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
