/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file DependencyDialog.h
 *    $short description$.
 *
 * @author Ronny Stricker
 * @date   2011/08/29
 */

#ifndef DEPENDENCYDIALOG_H_
#define DEPENDENCYDIALOG_H_

#include <QLabel>
#include <QDialog>
#include <QTreeView>

#include "core/Database.h"
#include "gui/PackageTreeModel.h"
#include "gui/PackageSortModel.h"

namespace mira {

class DependencyDialog : public QDialog
{
	Q_OBJECT
public:
	/**
	 * @brief constructs new dependency dialog
	 * @param rootPackage tree structure to confirm
	 * @param database install actions will be written to this database
	 */
	DependencyDialog( PackageGroup* rootPackage, Database* database,
	                  QWidget * parent = 0,
	                  Qt::WindowFlags f = Qt::WindowFlags() );
	
	virtual ~DependencyDialog();

	/**
	 * @brief Create pruned dependency tree according to the current selection
	 * in the depDatabase.
	 */
	void updateDependencies();

public slots:

	/**
	 * @brief write back the changes made in the current (pruned) dependency tree
	 * to the original database ( depDatabase)
	 */
	void ascribeChanges( QModelIndex const& index);
	virtual void accept();

	void mousePressed( QModelIndex const& index );

	void headerClicked(int column);

protected:
	PackageTreeModel* mPackageModel;
	PackageSortModel* mProxyModel;
	PackageGroup* mDepRoot;		///< pointer to root package of original dependency tree
	PackageGroup* mCurrentDep;	///< pointer to root package of internal dependency tree (pruned)
	QTreeView* mTreeView;

	Database* depDatabase;		///< changes of install actions will be marked in this database
	Database currentDatabase;	///< database associated with the mCurrentDep dependency tree
};

}


#endif /* DEPENDENCYDIALOG_H_ */
