/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file PromptProviderGui.h
 *    TODO Add description.
 *
 * @author ronny
 * @date   31.08.2011
 */

#ifndef _MIRA_PROMPTPROVIDERGUI_H_
#define _MIRA_PROMPTPROVIDERGUI_H_

#include <core/PromptProvider.h>

#include <QWidget>
#include <QDialog>

class QLineEdit;

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * @brief simple password dialog.
 * simple dialog for requesting user name and password.
 * If the user accepts the dialog, username and password will be stored in
 * mCredential.
 */
class PasswordDialog : public QDialog
{
	Q_OBJECT

public:
	PasswordDialog( Credential const& credential, QWidget * parent = 0,
	                Qt::WindowFlags f = Qt::WindowFlags() );

public slots:
	/**
	 * @brief set credential according to the current text of the username and
	 * password input boxes.
	 */
	virtual void accept( );

public:
	QLineEdit* mUserName;
	QLineEdit* mPassword;
	Credential mCredential;
};

///////////////////////////////////////////////////////////////////////////////

/**
 * @brief impementation of a GUI based implementation of the promptProvider.
 */
class PromptProviderGui : public PromptProvider {
public:
	PromptProviderGui( QWidget* parent ) : mParent( parent ) {}

	virtual bool getLogin( Credential& credential );

	virtual AcceptValue acceptServerCertificate( ServerCertificate const& certificate );

	virtual void showErrorMessage( std::string const& message );

	virtual bool showYesNoErrorMessage( std::string const& message );

protected:
	QWidget* mParent;

};

///////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
