/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file AbstractVideoOutput.h
 *    Abstract base class for video output writers.
 *
 * @author Erik Einhorn
 * @date   2013/01/22
 */

#ifndef _MIRA_ABSTRACTVIDEOOUTPUT_H_
#define _MIRA_ABSTRACTVIDEOOUTPUT_H_

#include <factory/Factory.h>

#include <image/Img.h>
#include <utils/Time.h>
#include <utils/ProgramOptions.h>

#include <video/VideoCodecsExports.h>

namespace mira { namespace video {

///////////////////////////////////////////////////////////////////////////////

class MIRA_VIDEOCODECS_EXPORT AbstractVideoOutput : public Object
{
	MIRA_ABSTRACT_OBJECT(AbstractVideoOutput)
public:
	virtual ~AbstractVideoOutput() {}

	/**
	 * Add codec options (to the command line parser).
	 */
	virtual void addProgramOptions(ProgramOptions::Description & description) = 0;

	/**
	 * Get the parsed and interpreted command line parameters.
	 */
	virtual void setProgramParameters(const ProgramOptions::VariableMap & vmap) = 0;

	/**
	 * Open a video file.
	 */
	virtual void open(const std::string& filename) = 0;

	/**
	 * Encode a frame (this is called for each frame).
	 */
	virtual void encode(const Img<>& image, const Time& timestamp) = 0;

	/**
	 * Finish and close the file.
	 */
	virtual void close() = 0;
};

typedef boost::shared_ptr<AbstractVideoOutput> AbstractVideoOutputPtr;

///////////////////////////////////////////////////////////////////////////////

}} // namespace

#endif
