/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

#include <serialization/BinarySerializer.h>
#include <image/Img.h>
#include <image/Color.h>

#include <opencv2/highgui/highgui.hpp>
#include <opencv2/imgproc/imgproc.hpp>

#include <codec/JpegCodec.h>
#include <codec/PngCodec.h>

using namespace mira;
using namespace mira::codec;
template <typename TImg>
TImg test(const TImg& img, BinarySerializerCodecPtr codec = BinarySerializerCodecPtr())
{
	if(codec) {
		std::cout << codec->getClass().getMetaInfo("Description") << ": " << std::endl;
	}

	// serialize
	Buffer<uint8> buf;
	BinaryBufferSerializer s(&buf);
	s.registerCodec(codec);

	s.serialize(img);
	std::cout << "Size: " << buf.size() << std::endl;

	// deserialize
	BinaryBufferDeserializer d(&buf);
	TImg out(640,480);
	d.deserialize(out);

	std::cout << (out == img) << std::endl;
	/*for(int y=0; y<img.height(); ++y)
		for(int x=0; x<img.height(); ++x)
			if(img3(x,y)!=img(x,y))
				std::cout << "("<<x<<","<<y<<"): "<< img3(x,y) << " vs " << img(x,y) << std::endl;
	 */

	//Img8U1 t = Img8U1::convertFrom(out);
	//cv::imshow("img3", t);
	return out;
}

int main()
{
	Img8U3 img(640,480);
	img = Color::Yellow;
	cv::line((cv::Mat&)img, Point2i(0,0), Point2i(640,480), Color::Blue);
	cv::line((cv::Mat&)img, Point2i(640,0), Point2i(0,480), Color::Blue);

	for(int i=0; i<100; ++i)
	{
		cv::circle((cv::Mat&)img, Point2i(320,240), 2*i+30, Color::Red);
		cv::line((cv::Mat&)img, Point2i(0,i*i	/20), Point2i(640,i*i/20), Color::Blue);
	}

	Img8U3 img2 = test(img);

	Img8U3 img3 = test(img, BinarySerializerCodecPtr(new JpegCodec(50)));
	Img8U3 img4 = test(img, BinarySerializerCodecPtr(new JpegCodec(95)));

	Img8U3 img5 = test(img, BinarySerializerCodecPtr(new PngCodec(3)));
	Img8U3 img6 = test(img, BinarySerializerCodecPtr(new PngCodec(9)));

	cv::imshow("img", img);
	cv::imshow("img3", img3);
	cv::imshow("img4", img4);
	cv::imshow("img5", img5);
	cv::imshow("img6", img6);
	cv::waitKey();


	return 0;
}
