/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file Z11Codec.h
 *    Codec for lossless compression of 11 bit depth images.
 *
 * @author Erik Einhorn
 * @date   2011/10/01
 */

#ifndef _MIRA_Z11CODEC_H_
#define _MIRA_Z11CODEC_H_

#include <serialization/BinarySerializerCodec.h>

#include <codec/CommonCodecsExports.h>

namespace mira { namespace codec {

///////////////////////////////////////////////////////////////////////////////

/**
 * Codec for lossless compression of 11 bit depth images (like Kinect depth
 * images) that can be used together with a BinarySerializer.
 * Depth images are compressed using a Variable Bit Width Encoding (ZBWE).
 * The codec computes the depth value differences between consecutive pixels.
 * Smaller differences occur more often in depth images and are stored using
 * few bits only. Larger differences are stored with more bits, but their
 * occurrence is rare.
 */
class MIRA_COMMONCODECS_EXPORT Z11Codec : public BinarySerializerCodec
{
MIRA_META_OBJECT(Z11Codec,
		("FOURCC",      "ZBWE")
		("Name",        "ZBWE")
		("Description", "Lossless compression of 11bit depth images (i.e. max. depth values <2048 !)")
		("Category"   , "Image"))

public:

	template <typename Reflector>
	void reflect(Reflector &r)
	{
	}

public:

	/// Implementation of BinarySerializerCodec
	virtual TypeId getSupportedTypeId() const;

protected:

	/// Implementation of BinarySerializerCodec
	virtual Buffer<uint8> encodeBuffer(TypedVoidConstPtr objectPtr);

	/// Implementation of BinarySerializerCodec
	virtual void decodeBuffer(const Buffer<uint8>& data, TypedVoidPtr ioObjectPtr);
};

///////////////////////////////////////////////////////////////////////////////

}} // namespace

#endif
