###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
#
# Provide some macro for the MIRA documentation tag file handling mechanism.
#
# Author: Tim Langner
#
###############################################################################

###############################################################################
# The following code is executed during the initial 'cmake' process,
# which configures the build environment.
# The code looks for tag files (*.tag) and stores them in the list variable
# DOXYGEN_DOCTAG_FILES
###############################################################################

# MIRA_PATH comes from Prerequisites.cmake
MACRO( INDEX_ALL_DOCTAGS )

	SET(DOXYGEN_DOCTAG_FILES "")
	FOREACH(doctag_searchPath ${MIRA_PATH})
		set(tagfiles "")
		MESSAGE(STATUS "Looking for tag files in ${doctag_searchPath}:")
		FILE(GLOB_RECURSE MIRA_ALL_DOCTAGS "${doctag_searchPath}/doc/*.tag")
		FOREACH(doctag_fullPath ${MIRA_ALL_DOCTAGS})
			GET_FILENAME_COMPONENT(filename ${doctag_fullPath} NAME)
			GET_FILENAME_COMPONENT(doctagName ${doctag_fullPath} NAME_WE)
			set(tagfiles "${tagfiles} ${doctagName}")
			LIST(APPEND DOXYGEN_DOCTAG_FILES "${doctagName} ${doctag_fullPath}")
		ENDFOREACH(doctag_fullPath)
		MESSAGE("${tagfiles}")
	ENDFOREACH(doctag_searchPath)
	MESSAGE(STATUS "Finished looking for tag files")

ENDMACRO( INDEX_ALL_DOCTAGS )

###############################################################################

MACRO(MIRA_FIND_DOCTAG name)

	SET(DOCTAG_${name}_FOUND "FALSE")
	FOREACH(doctag_searchPath ${DOXYGEN_DOCTAG_FILES})
		SEPARATE_ARGUMENTS(doctag_searchPath)
		LIST(GET doctag_searchPath 0 doctagName)
		STRING(COMPARE EQUAL "${doctagName}" "${name}" found)
		IF(found)
			LIST(GET doctag_searchPath 1 doctagFullPath)
			SET(DOCTAG_${name}_FOUND "TRUE")
			SET(DOCTAG_${name}_PATH ${doctagFullPath})
			BREAK()
		ENDIF(found)
	ENDFOREACH(doctag_searchPath)
	
ENDMACRO(MIRA_FIND_DOCTAG)

###############################################################################

MACRO(MIRA_ADD_DOCTAG_TO_INDEX doctagName doctagFullPath)

	# Search for the doctagName in the index.
	MIRA_FIND_DOCTAG(${doctagName})
	IF ( NOT DOCTAG_${doctagName}_FOUND )
		# only add to index, if it not exists yet
		LIST(APPEND DOXYGEN_DOCTAG_FILES "${doctagName} ${doctagFullPath}")
	ENDIF()

ENDMACRO(MIRA_ADD_DOCTAG_TO_INDEX)
