/*
 * Copyright (C) 2018 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file ChannelTypes.C
 *    Register a selection of primitive, standard and MIRABase types
 *    (for automatic promotion to typed channel).
 *
 * @author Christof Schröter
 * @date   2018/09/02
 */

#include <fw/ChannelPromoteByTypenameRegistration.h>

#include <image/Img.h>
#include <transform/Pose.h>

///////////////////////////////////////////////////////////////////////////////

// Register channels that should be available for automatic promotion from
// untyped to typed channels.
// Promotion is required e.g. with remote framework connection (if there is no
// local typed subscriber) or tape playback.

// Use typedefs to avoid ',' in macro argument. These won't go out of this
// file, so name choice is free (registered name will be the base type name,
// as is the channel type name anyway)

MIRA_REGISTER_CHANNELTYPE(bool);
MIRA_REGISTER_CHANNELTYPE(char);
MIRA_REGISTER_CHANNELTYPE(int);
MIRA_REGISTER_CHANNELTYPE(int64);
MIRA_REGISTER_CHANNELTYPE(uchar);
MIRA_REGISTER_CHANNELTYPE(uint);
MIRA_REGISTER_CHANNELTYPE(uint64);
MIRA_REGISTER_CHANNELTYPE(float);
MIRA_REGISTER_CHANNELTYPE(double);
MIRA_REGISTER_CHANNELTYPE(std::string);

MIRA_REGISTER_CHANNELTYPE(mira::Point2i);
MIRA_REGISTER_CHANNELTYPE(mira::Point2f);
MIRA_REGISTER_CHANNELTYPE(mira::Point2d);
MIRA_REGISTER_CHANNELTYPE(mira::Point3i);
MIRA_REGISTER_CHANNELTYPE(mira::Point3f);
MIRA_REGISTER_CHANNELTYPE(mira::Point3d);

MIRA_REGISTER_CHANNELTYPE(mira::Pose2);
MIRA_REGISTER_CHANNELTYPE(mira::Pose3);
MIRA_REGISTER_CHANNELTYPE(mira::PoseCov2);
MIRA_REGISTER_CHANNELTYPE(mira::PoseCov3);

MIRA_REGISTER_CHANNELTYPE(mira::SignedAnglef);
MIRA_REGISTER_CHANNELTYPE(mira::SignedAngled);

MIRA_REGISTER_CHANNELTYPE(mira::Anglef);
MIRA_REGISTER_CHANNELTYPE(mira::Angled);

MIRA_REGISTER_CHANNELTYPE(mira::Img<>);
MIRA_REGISTER_CHANNELTYPE(mira::Img8U1);
MIRA_REGISTER_CHANNELTYPE(mira::Img8U3);
MIRA_REGISTER_CHANNELTYPE(mira::Img8U4);
MIRA_REGISTER_CHANNELTYPE(mira::Img32F1);

MIRA_REGISTER_CHANNELTYPE(mira::json::Value);
MIRA_REGISTER_CHANNELTYPE(mira::json::Object);
MIRA_REGISTER_CHANNELTYPE(mira::json::Array);
