/*
 * Copyright (C) by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file TraitsTest.C
 *    Test cases for IsDefaultConstructible, IsCopyAssignable.
 *
 * @author Christof Schröter
 * @date   2011/09/24
 */

#include <boost/test/unit_test.hpp>

#include <boost/noncopyable.hpp>

#include <utils/IsDefaultConstructible.h>
#include <utils/IsCopyAssignable.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

struct DefaultStruct {};

struct CopyStruct
{
	CopyStruct(int) {}
	CopyStruct(const CopyStruct&) {}
};

struct NonCopyStruct : public boost::noncopyable {};

struct NonCopyContainer : public std::vector<NonCopyStruct> {};

// needs trait specialization

template <>
class IsCopyAssignable<NonCopyContainer> : public std::false_type {};

///////////////////////////////////////////////////////////////////////////////

} // namespace

using namespace mira;

BOOST_AUTO_TEST_CASE( IsDefaultConstructibleTest )
{
	// int i; // ok
	BOOST_CHECK_EQUAL(true, IsDefaultConstructible<int>::value);

	// DefaultStruct d; // ok
	BOOST_CHECK_EQUAL(true, IsDefaultConstructible<DefaultStruct>::value);

	// CopyStruct c; // not ok
	BOOST_CHECK_EQUAL(false, IsDefaultConstructible<CopyStruct>::value);

	// NonCopyStruct n; // ok
	BOOST_CHECK_EQUAL(true, IsDefaultConstructible<NonCopyStruct>::value);

	// std::vector<boost::noncopyable> v; // ok
	BOOST_CHECK_EQUAL(true, IsDefaultConstructible<std::vector<boost::noncopyable>>::value);
}

BOOST_AUTO_TEST_CASE( IsCopyAssignableTest )
{
	// int i, i2;
	// i = i2; // ok
	BOOST_CHECK_EQUAL(true, IsCopyAssignable<int>::value);

	// DefaultStruct d, d2;
	// d = d2; // ok
	BOOST_CHECK_EQUAL(true, IsCopyAssignable<DefaultStruct>::value);

	// CopyStruct c(1), c2(2);
	// c = c2; // ok
	BOOST_CHECK_EQUAL(true, IsCopyAssignable<CopyStruct>::value);

	// NonCopyStruct n, n2;
	// n = n2; // not ok
	BOOST_CHECK_EQUAL(false, IsCopyAssignable<NonCopyStruct>::value);

	// std::vector<boost::noncopyable> v, v2;
	// v = v2; // not ok

	BOOST_CHECK_EQUAL(false, IsCopyAssignable<NonCopyContainer>::value);
}
