/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * Example for using BinarySerializer for serializing/deserializing
 * objects that can be streamed via tcp or stored on in files
 * (e.g. logfiles)
 */

#include "Example.h"

#include <serialization/BinarySerializer.h>
#include <serialization/JSONSerializer.h>
#include <serialization/Print.h>

#include <boost/type_traits/is_polymorphic.hpp>

using namespace mira;
using namespace std;


void send( Buffer<uint8>& buffer, int val)
{
	// generate some demo data
	MyClass2 obj;
	for(int i=0; i<val+1; ++i)
		obj.mPoses.push_back(Pose((float)i,(float)(i+1),(float)(i+2)));

	// set some pointers to other members
	//obj.mPosePtr= &obj.mPoses[val/2];
	obj.mPosePtr= NULL;
	obj.mPtr= &obj.mPoses[val/2].phi;


	// stream the data!
	BinaryBufferSerializer s(&buffer);
	s.serialize(obj);

	// that's it
}


void receive( Buffer<uint8>& buffer)
{
	MyClass2 obj;

	// deserialize the data from the stream
	//BinaryBufferIstream bis(buffer); // wrap binary stream
	BinaryBufferDeserializer d(&buffer);
	d.deserialize(obj);

	cout << "####################################################" << endl;
	cout << "Received Data: " << endl;
	cout << print(obj) << endl;
}


int main()
{
	Buffer<uint8> buffer;
	for(int i=0; i<10; ++i)
	{
		send(buffer, i);

		// ...
		// send ss through tcp or write it into a file

		// receive ss from tcp or read it from file
		// ...

		receive(buffer);
	}


    return 0;
}
